/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_329;
import net.minecraft.class_4008;
import net.minecraft.class_4341;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_6628;
import net.minecraft.class_7569;
import net.minecraft.class_7574;
import net.minecraft.class_7578;
import net.minecraft.class_7853;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.mixin.base.RealmsAvailabilityAccessor;

@Mixin(value={class_310.class})
public abstract class MinecraftMixin
implements MinecraftAccessor {
    @Shadow
    @Nullable
    public class_638 field_1687;
    @Shadow
    @Final
    public class_329 field_1705;
    @Mutable
    @Shadow
    @Final
    private class_320 field_1726;
    @Mutable
    @Shadow
    @Final
    private class_7853 field_39068;
    @Mutable
    @Shadow
    @Final
    private UserApiService field_26902;
    @Mutable
    @Shadow
    @Final
    private CompletableFuture<ProfileResult> field_45899;
    @Mutable
    @Shadow
    @Final
    private CompletableFuture<UserApiService.UserProperties> field_47680;
    @Shadow
    @Final
    private YggdrasilAuthenticationService field_39420;
    @Mutable
    @Shadow
    @Final
    private class_6628 field_41331;
    @Shadow
    @Final
    private static Logger field_1762;
    @Shadow
    private class_7574 field_39492;
    @Mutable
    @Shadow
    @Final
    private class_7578 field_39718;
    @Shadow
    @Final
    private class_4008 field_17763;

    @Inject(method={"resizeDisplay"}, at={@At(value="RETURN")})
    public void resizeDisplay(CallbackInfo ci) {
        if (this.field_1687 != null) {
            UIAccessor.of(this.field_1705).reloadUI();
            ((Consumer)FactoryAPIClient.RESIZE_DISPLAY.invoker).accept(class_310.method_1551());
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="RETURN")})
    public void setScreen(class_437 screen, CallbackInfo ci) {
        if (this.field_1687 != null) {
            UIAccessor.of(this.field_1705).reloadUI();
        }
    }

    @Inject(method={"stop"}, at={@At(value="RETURN")})
    public void stop(CallbackInfo ci) {
        ((Consumer)FactoryAPIClient.STOPPING.invoker).accept(class_310.method_1551());
    }

    @Override
    @Accessor
    public abstract float getPausePartialTick();

    @Override
    public boolean hasGameLoaded() {
        return class_310.method_1551().method_53466();
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V")})
    public void beforeScreenTick(CallbackInfo ci) {
        if (class_310.method_1551().field_1755 == null) {
            return;
        }
        UIAccessor accessor = UIAccessor.of(class_310.method_1551().field_1755);
        class_437.method_25412(accessor::beforeTick, (String)"Ticking screen before tick", (String)class_310.method_1551().field_1755.getClass().getCanonicalName());
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;wrapScreenError(Ljava/lang/Runnable;Ljava/lang/String;Ljava/lang/String;)V", shift=At.Shift.AFTER)})
    public void afterScreenTick(CallbackInfo ci) {
        if (class_310.method_1551().field_1755 == null) {
            return;
        }
        UIAccessor accessor = UIAccessor.of(class_310.method_1551().field_1755);
        class_437.method_25412(accessor::afterTick, (String)"Ticking screen after tick", (String)class_310.method_1551().field_1755.getClass().getCanonicalName());
    }

    @Override
    public boolean setUser(class_320 user) {
        if (user == null) {
            field_1762.warn("Something went wrong, the User cannot be set to null");
            return false;
        }
        this.field_1726 = this.field_17763.field_18934 = user;
        MinecraftSessionService session = class_310.method_1551().method_1495();
        boolean offlineDeveloperMode = user.method_35718() != class_320.class_321.field_34962;
        this.field_45899 = CompletableFuture.supplyAsync(() -> session.fetchProfile(user.method_44717(), true), class_156.method_55473());
        this.field_26902 = offlineDeveloperMode ? UserApiService.OFFLINE : this.field_39420.createUserApiService(user.method_1674());
        this.field_47680 = CompletableFuture.supplyAsync(() -> {
            try {
                return this.field_26902.fetchProperties();
            }
            catch (AuthenticationException var2) {
                field_1762.error("Failed to fetch user properties", (Throwable)var2);
                return UserApiService.OFFLINE_PROPERTIES;
            }
        }, class_156.method_55473());
        this.field_39068 = class_7853.method_46532((UserApiService)this.field_26902, (class_320)user, (Path)class_310.method_1551().field_1697.toPath());
        this.field_41331 = new class_6628(class_310.method_1551(), this.field_26902, user);
        this.field_39492 = class_7574.method_44599((class_7569)class_7569.method_44586(), (UserApiService)this.field_26902);
        this.field_39718 = new class_7578(class_4341.method_20989((class_310)class_310.method_1551()));
        RealmsAvailabilityAccessor.setFuture(null);
        return true;
    }
}

