/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.Rect2i;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.drawable.DrawableStatic;
import wily.factoryapi.util.FactoryScreenUtil;

public interface IWindowWidget
extends GuiEventListener,
Renderable {
    default public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        for (Renderable renderable : this.getNestedRenderables()) {
            GuiEventListener listener;
            if (!(renderable instanceof GuiEventListener) || !(listener = (GuiEventListener)renderable).mouseClicked(mouseButtonEvent, bl)) continue;
            return true;
        }
        return false;
    }

    default public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
        for (Renderable renderable : this.getNestedRenderables()) {
            GuiEventListener listener;
            if (!(renderable instanceof GuiEventListener) || !(listener = (GuiEventListener)renderable).mouseReleased(mouseButtonEvent)) continue;
            return true;
        }
        return false;
    }

    default public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double f, double g) {
        for (Renderable renderable : this.getNestedRenderables()) {
            GuiEventListener listener;
            if (!(renderable instanceof GuiEventListener) || !(listener = (GuiEventListener)renderable).mouseDragged(mouseButtonEvent, f, g)) continue;
            return true;
        }
        return false;
    }

    default public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        for (Renderable renderable : this.getNestedRenderables()) {
            renderable.render(guiGraphics, i, j, f);
        }
    }

    default public void playDownSound(float grave) {
        FactoryScreenUtil.playButtonDownSound(grave);
    }

    public Rect2i getBounds();

    public boolean isVisible();

    default public ScreenRectangle getRectangle() {
        return FactoryScreenUtil.rect2iToRectangle(this.getBounds());
    }

    public <R extends Renderable> R addNestedRenderable(R var1);

    public List<? extends Renderable> getNestedRenderables();

    default public ArbitrarySupplier<Renderable> getNestedAt(int x, int y) {
        for (Renderable renderable : this.getNestedRenderables()) {
            DrawableStatic drawable;
            LayoutElement layout;
            if (renderable instanceof LayoutElement && FactoryScreenUtil.isMouseOver(x, y, (layout = (LayoutElement)renderable).getX(), layout.getY(), layout.getHeight(), layout.getWidth())) {
                return () -> nested;
            }
            if (!(renderable instanceof DrawableStatic) || !(drawable = (DrawableStatic)renderable).inMouseLimit(x, y)) continue;
            return () -> nested;
        }
        return ArbitrarySupplier.empty();
    }
}

