/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.MipmapMetadataSection;

@Mixin(value={SpriteContents.class})
public abstract class SpriteContentsMixin {
    @Shadow
    NativeImage[] byMipLevel;

    @Shadow
    public abstract <T> Optional<T> getAdditionalMetadata(MetadataSectionType<T> var1);

    @Shadow
    public abstract ResourceLocation name();

    @Inject(method={"increaseMipLevel"}, at={@At(value="RETURN")})
    public void increaseMipLevel(int i, CallbackInfo ci) {
        if (!((Boolean)FactoryOptions.MANUAL_MIPMAP.get()).booleanValue()) {
            return;
        }
        MipmapMetadataSection manualMipmap = this.getAdditionalMetadata(MipmapMetadataSection.TYPE).orElseGet(() -> MipmapMetadataSection.createFallback((SpriteContents)this, i));
        NativeImage original = this.byMipLevel[0];
        for (Map.Entry<Integer, MipmapMetadataSection.Level> entry : manualMipmap.levels().entrySet()) {
            if (entry.getKey() > i) break;
            NativeImage image = entry.getValue().image();
            int divisor = (int)Math.pow(2.0, entry.getKey().intValue());
            int width = original.getWidth() / divisor;
            int height = original.getHeight() / divisor;
            if (image == null) {
                FactoryAPI.LOGGER.error("Failed to replace generated mipmap from texture {}: {} failed to load", (Object)this.name(), (Object)entry.getValue().texture());
                continue;
            }
            if (image.getWidth() != width || image.getHeight() != height) {
                FactoryAPI.LOGGER.error("Failed to replace generated mipmap from texture {}: {} has an incorrect size, it should be {}x{}", (Object)this.name(), (Object)entry.getValue().texture(), (Object)width, (Object)height);
                continue;
            }
            this.byMipLevel[entry.getKey().intValue()] = image;
        }
    }
}

