/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.IFactoryExpandedStorage;
import wily.factoryapi.base.IModifiableTransportHandler;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.FactoryItemUtil;

public class FactoryItemHandler
extends SimpleContainer
implements IPlatformItemHandler {
    protected BlockEntity be;
    protected TransportState transportState;

    public FactoryItemHandler(int inventorySize, BlockEntity be, TransportState transportState) {
        super(inventorySize);
        this.be = be;
        this.transportState = transportState;
    }

    public boolean m_271862_(Container container, int i, ItemStack itemStack) {
        return this.getTransport().canExtract();
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        IFactoryExpandedStorage storage;
        BlockEntity blockEntity;
        return this.getTransport().canInsert() && (!((blockEntity = this.be) instanceof IFactoryExpandedStorage) || ((FactoryItemSlot)(storage = (IFactoryExpandedStorage)blockEntity).getSlots(null).get(slot)).m_5857_(stack));
    }

    public FactoryItemHandler(IPlatformItemHandler handler, TransportState transportState) {
        BlockEntity blockEntity;
        int n = handler.m_6643_();
        if (handler instanceof FactoryItemHandler) {
            FactoryItemHandler h = (FactoryItemHandler)handler;
            blockEntity = h.be;
        } else {
            blockEntity = null;
        }
        this(n, blockEntity, transportState);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.m_8020_(slot);
        if (!stackInSlot.m_41619_()) {
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), this.m_6893_())) {
                return stack;
            }
            if (!FactoryItemUtil.equalItems(stack, stackInSlot)) {
                return stack;
            }
            if (!this.m_7013_(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.m_41741_(), this.m_6893_()) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    this.m_6836_(slot, copy);
                    this.m_6596_();
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                this.m_6836_(slot, copy);
                this.m_6596_();
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!this.m_7013_(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.m_41741_(), this.m_6893_());
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                this.m_6836_(slot, stack.m_41620_(m));
                this.m_6596_();
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!simulate) {
            this.m_6836_(slot, stack);
            this.m_6596_();
        }
        return ItemStack.f_41583_;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || !this.m_271862_(this, slot, this.m_8020_(slot))) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.m_8020_(slot);
        if (stackInSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            if (stackInSlot.m_41613_() < amount) {
                return stackInSlot.m_41777_();
            }
            ItemStack copy = stackInSlot.m_41777_();
            copy.m_41764_(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.m_41613_(), amount);
        ItemStack decrStackSize = this.m_7407_(slot, m);
        this.m_6596_();
        return decrStackSize;
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.be != null) {
            this.be.m_6596_();
        }
    }

    @Override
    public CompoundTag serializeTag() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            this.m_8020_(i).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    @Override
    public boolean m_6542_(@NotNull Player player) {
        return this.be == null || Container.m_272074_((BlockEntity)this.be, (Player)player);
    }

    @Override
    public void deserializeTag(CompoundTag tag) {
        ListTag tagList = tag.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.m_6643_()) continue;
            this.m_6836_(slot, ItemStack.m_41712_((CompoundTag)itemTags));
        }
    }

    public ItemStack m_19173_(ItemStack itemStack) {
        return super.m_19173_(itemStack);
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }

    @Override
    public boolean isRemoved() {
        return this.be != null && this.be.m_58901_();
    }

    public static class SidedWrapper
    extends FactoryItemHandler
    implements IModifiableTransportHandler {
        private final IPlatformItemHandler platformItemHandler;
        public int[] slots = new int[0];

        public SidedWrapper(IPlatformItemHandler platformItemHandler) {
            super(platformItemHandler, platformItemHandler.getTransport());
            this.platformItemHandler = platformItemHandler;
        }

        @Override
        public boolean m_7013_(int i, @NotNull ItemStack arg) {
            return this.platformItemHandler.m_7013_(i, arg) && ArrayUtils.contains((int[])this.slots, (int)i);
        }

        @Override
        public boolean m_271862_(Container container, int i, ItemStack itemStack) {
            return this.platformItemHandler.m_271862_(container, i, itemStack) && ArrayUtils.contains((int[])this.slots, (int)i);
        }

        @Override
        public ItemStack m_8020_(int i) {
            return ArrayUtils.contains((int[])this.slots, (int)i) ? this.platformItemHandler.m_8020_(i) : ItemStack.f_41583_;
        }

        @Override
        public ItemStack m_7407_(int i, int j) {
            return this.platformItemHandler.m_7407_(i, j);
        }

        @Override
        public ItemStack m_8016_(int i) {
            return this.platformItemHandler.m_8016_(i);
        }

        public void m_6836_(int i, ItemStack arg) {
            this.platformItemHandler.m_6836_(i, arg);
        }

        @Override
        public void setTransport(TransportState state) {
            this.transportState = state;
        }
    }
}

