/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.config;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.config.FactoryConfigDisplay;

public class FactoryMixinToggle
extends Stocker<Boolean> {
    public static final Logger LOGGER = LogManager.getLogger((String)"factory_mixin_config");
    public final String key;
    public final boolean defaultValue;
    public final ArbitrarySupplier<FactoryConfigDisplay<Boolean>> configDisplay;

    public FactoryMixinToggle(String key, Boolean defaultValue, ArbitrarySupplier<FactoryConfigDisplay<Boolean>> configDisplay) {
        super(defaultValue);
        this.key = key;
        this.defaultValue = defaultValue;
        this.configDisplay = configDisplay;
    }

    public record Storage(File file, Map<String, FactoryMixinToggle> configMap) {
        public Storage(File file) {
            this(file, new HashMap<String, FactoryMixinToggle>());
        }

        public Storage(String configDirectoryFile) {
            this(FactoryAPI.getConfigDirectory().resolve(configDirectoryFile).toFile());
        }

        public FactoryMixinToggle register(String key, FactoryMixinToggle config) {
            this.configMap.put(key, config);
            return config;
        }

        public FactoryMixinToggle register(FactoryMixinToggle config) {
            return this.register(config.key, config);
        }

        public boolean get(String key) {
            return !this.configMap.containsKey(key) || (Boolean)this.configMap.get(key).get() != false;
        }

        public boolean getFormatted(String target, String key) {
            return this.get(this.format(target, key));
        }

        public String format(String target, String mixinClass) {
            mixinClass = mixinClass.replace(target, "");
            return mixinClass.substring(0, mixinClass.lastIndexOf("."));
        }

        public void load() {
            if (!this.file.exists()) {
                this.save();
                return;
            }
            try (BufferedReader r = Files.newReader((File)this.file, (Charset)Charsets.UTF_8);){
                JsonParser.parseReader((Reader)r).getAsJsonObject().asMap().forEach((s, e) -> {
                    FactoryMixinToggle config = this.configMap.get(s);
                    if (config == null) {
                        LOGGER.warn("Config named as {} from {} config file wasn't found", s, (Object)this.file.toString());
                    } else {
                        config.set(e.getAsBoolean());
                    }
                });
            }
            catch (IOException e2) {
                LOGGER.warn("Failed to load the config {}: {}", (Object)this.file.toString(), (Object)e2);
            }
        }

        public void save() {
            File parent = this.file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try (JsonWriter w = new JsonWriter((Writer)Files.newWriter((File)this.file, (Charset)Charsets.UTF_8));){
                w.setSerializeNulls(false);
                w.setIndent("  ");
                JsonObject obj = new JsonObject();
                this.configMap.forEach((s, config) -> obj.add(s, (JsonElement)new JsonPrimitive((Boolean)config.get())));
                GsonHelper.m_216207_((JsonWriter)w, (JsonElement)obj, Comparator.naturalOrder());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to save the config {}: {}", (Object)this.file.toString(), (Object)e);
            }
        }
    }
}

