/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import org.joml.Quaternionf;

public class DirectionUtil {
    public static Direction nearestRotation(float rotateX, float rotateY, boolean invertYAxis) {
        ItemEntity entity = new ItemEntity(EntityType.f_20461_, null);
        entity.m_146926_(rotateX);
        entity.m_146922_(rotateY);
        Direction d = Direction.m_122382_((Entity)entity)[0];
        return Direction.Plane.VERTICAL.test(d) && invertYAxis ? d.m_122424_() : d;
    }

    public static float rotationCyclic(float rotation) {
        if (rotation > 180.0f) {
            return rotation - 360.0f;
        }
        if (rotation < 180.0f) {
            return 360.0f + rotation;
        }
        return rotation;
    }

    public static float unCyclicRotation(float rotation) {
        return rotation < 0.0f ? 360.0f + rotation : rotation;
    }

    public static double rotateByCenter(Direction.Axis axis, double angle, double center, double centerXDistance, double centerZDistance) {
        switch (axis) {
            default: {
                return center;
            }
            case X: {
                return center + centerXDistance * Math.cos(angle) - centerZDistance * Math.sin(angle);
            }
            case Z: 
        }
        return center + centerXDistance * Math.sin(angle) + centerZDistance * Math.cos(angle);
    }

    public static double rotateZByCenter(double angle, double center, double centerXDistance, double centerZDistance) {
        return DirectionUtil.rotateByCenter(Direction.Axis.Z, angle, center, centerXDistance, centerZDistance);
    }

    public static double rotateXByCenter(double angle, double center, double centerXDistance, double centerZDistance) {
        return DirectionUtil.rotateByCenter(Direction.Axis.X, angle, center, centerXDistance, centerZDistance);
    }

    public static Quaternionf getRotation(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> Axis.f_252529_.m_252977_(180.0f);
            case Direction.UP -> new Quaternionf();
            case Direction.NORTH -> Axis.f_252529_.m_252977_(-90.0f);
            case Direction.SOUTH -> Axis.f_252529_.m_252977_(90.0f);
            case Direction.WEST -> Axis.f_252403_.m_252977_(90.0f);
            case Direction.EAST -> Axis.f_252403_.m_252977_(-90.0f);
        };
    }

    public static Quaternionf getNorthRotation(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> Axis.f_252529_.m_252977_(-90.0f);
            case Direction.UP -> Axis.f_252529_.m_252977_(90.0f);
            case Direction.NORTH -> new Quaternionf();
            case Direction.SOUTH -> Axis.f_252436_.m_252977_(180.0f);
            case Direction.WEST -> Axis.f_252436_.m_252977_(90.0f);
            case Direction.EAST -> Axis.f_252436_.m_252977_(-90.0f);
        };
    }

    public static Quaternionf getRotationByInitial(Direction initial, Direction direction) {
        Direction.Axis axis2;
        Direction.Axis axis1 = initial.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        Direction.Axis axis = axis2 = initial.m_122434_() == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y;
        if (direction == initial.m_122424_()) {
            return Axis.f_252529_.m_252977_(180.0f);
        }
        if (direction == initial) {
            return new Quaternionf();
        }
        if (direction == initial.m_175362_(Direction.Axis.X)) {
            return Axis.f_252529_.m_252977_(-90.0f);
        }
        if (direction == initial.m_175364_(Direction.Axis.X)) {
            return Axis.f_252529_.m_252977_(90.0f);
        }
        if (direction == initial.m_175364_(Direction.Axis.Z)) {
            return Axis.f_252403_.m_252977_(90.0f);
        }
        if (direction == initial.m_175362_(Direction.Axis.Z)) {
            return Axis.f_252403_.m_252977_(-90.0f);
        }
        return new Quaternionf();
    }

    public static Quaternionf getHorizontalRotation(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> new Quaternionf();
            case Direction.SOUTH -> Axis.f_252436_.m_252977_(180.0f);
            case Direction.WEST -> Axis.f_252436_.m_252977_(90.0f);
            case Direction.EAST -> Axis.f_252436_.m_252977_(-90.0f);
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

