/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import wily.factoryapi.FactoryAPI;

public class FactoryItemUtil {
    public static CompoundTag getFromJson(JsonObject obj) {
        return CompoundTag.f_128325_.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).result().orElseGet(CompoundTag::new);
    }

    public static List<Item> getItemComponents(ItemStack itemStack) {
        ArrayList<Item> list = new ArrayList<Item>();
        if (itemStack.m_41782_() && !itemStack.m_41783_().m_128437_("Components", 8).isEmpty()) {
            itemStack.m_41783_().m_128437_("Components", 8).forEach(t -> list.add((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(t.m_7916_()))));
        }
        return list;
    }

    public static boolean equalItems(ItemStack itemStack, ItemStack itemStack1) {
        return ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)itemStack1);
    }

    public static boolean compareItems(ItemStack itemStack, ItemStack itemStack1, boolean checkCount) {
        return FactoryItemUtil.compareItems(itemStack, itemStack1, checkCount, true);
    }

    public static boolean compareItems(ItemStack itemStack, ItemStack itemStack1, boolean checkCount, boolean strict) {
        if (strict) {
            if (checkCount) {
                return ItemStack.m_41728_((ItemStack)itemStack, (ItemStack)itemStack1);
            }
            return FactoryItemUtil.equalItems(itemStack, itemStack1);
        }
        if (ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)itemStack1) && (!checkCount || itemStack.m_41613_() == itemStack1.m_41613_())) {
            return NbtUtils.m_129235_((Tag)itemStack.m_41783_(), (Tag)itemStack1.m_41783_(), (boolean)true);
        }
        return false;
    }

    public static boolean hasCustomName(ItemStack stack) {
        return stack.m_41788_();
    }

    public static void setCustomName(ItemStack stack, Component name) {
        if (name == null) {
            stack.m_41787_();
        } else {
            stack.m_41714_(name);
        }
    }

    public static int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return FactoryItemUtil.getEnchantmentLevel(stack, enchantment, (RegistryAccess)FactoryAPI.currentServer.m_206579_());
    }

    public static int getEnchantmentLevel(ItemStack stack, Enchantment enchantment, RegistryAccess registryAccess) {
        return EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)stack);
    }
}

