/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.util.CompoundTagUtil;

public class FluidInstance {
    private final Fluid fluid;
    private int amount;
    private CompoundTag tag;
    public static final Codec<FluidInstance> CODEC = RecordCodecBuilder.create((T i) -> i.group((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf("fluid").forGetter(FluidInstance::getFluid), (App)Codec.INT.fieldOf("amount").forGetter(FluidInstance::getAmount), (App)CompoundTag.f_128325_.fieldOf("nbt").forGetter(FluidInstance::getNonNullTag)).apply((Applicative)i, FluidInstance::new));
    public static final FluidInstance EMPTY = new FluidInstance(Fluids.f_76191_, 0);
    private FluidStack stack;

    public FluidInstance(Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public FluidInstance(Fluid fluid, int amount, CompoundTag tag) {
        this(fluid, amount);
        this.tag = tag.m_6426_();
    }

    public static FluidInstance empty() {
        return EMPTY;
    }

    public static FluidInstance create(FluidInstance fluidInstance, int amount) {
        return FluidInstance.create(fluidInstance.getFluid(), amount);
    }

    public static FluidInstance create(Fluid fluid, int amount) {
        return new FluidInstance(fluid, amount);
    }

    public static FluidInstance create(Fluid fluid) {
        return new FluidInstance(fluid, 1000);
    }

    public static FluidInstance create(Fluid fluid, long amount) {
        return new FluidInstance(fluid, FluidInstance.getMilliBucketsFluidAmount(amount));
    }

    public CompoundTag getNonNullTag() {
        return this.getTag() == null ? new CompoundTag() : this.getTag();
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public void setTag(CompoundTag tag) {
        if (this.getFluid() != Fluids.f_76191_) {
            this.tag = tag;
        }
    }

    public CompoundTag getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new CompoundTag());
        }
        return this.tag;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean isEmpty() {
        return this.getAmount() <= 0;
    }

    public int getAmount() {
        return this.getFluid() == Fluids.f_76191_ ? 0 : this.amount;
    }

    public long getPlatformAmount() {
        return FluidInstance.getPlatformFluidAmount(this.getAmount());
    }

    public void setAmount(int amount) {
        if (this.getFluid() != Fluids.f_76191_) {
            this.amount = amount;
        }
    }

    public FluidStack toStack() {
        if (this.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.stack == null) {
            this.stack = new FluidStack(this.fluid, this.amount);
        }
        this.stack.setAmount(this.amount);
        this.stack.setTag(this.getTag());
        return this.stack;
    }

    public void setAmount(long amount) {
        this.setAmount(FluidInstance.getMilliBucketsFluidAmount(amount));
    }

    public static FluidInstance fromJson(JsonObject jsonObject) {
        if (jsonObject != null) {
            return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().orElse(FluidInstance.empty());
        }
        return FluidInstance.empty();
    }

    public static FluidInstance fromTag(CompoundTag tag) {
        return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).result().orElseGet(() -> {
            Optional<String> fluidId = CompoundTagUtil.getString(tag, "FluidName");
            if (fluidId.isPresent()) {
                Fluid fluid = (Fluid)FactoryAPIPlatform.getRegistryValue(FactoryAPI.createLocation(fluidId.get()), BuiltInRegistries.f_257020_);
                if (fluid == Fluids.f_76191_) {
                    return FluidInstance.empty();
                }
                return FluidInstance.create(fluid, FluidInstance.getMilliBucketsFluidAmount(CompoundTagUtil.getLong(tag, "Amount").orElse(0L)));
            }
            return FluidInstance.empty();
        });
    }

    public static CompoundTag toTag(FluidInstance stack) {
        return CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)stack).result().map(t -> {
            CompoundTag c;
            return t instanceof CompoundTag ? (c = (CompoundTag)t) : null;
        }).orElse(new CompoundTag());
    }

    public static long getPlatformBucketFluidAmount() {
        return FactoryAPI.getLoader().isFabric() ? 81000L : 1000L;
    }

    public static long getPlatformFluidAmount(int amount) {
        return (long)((float)amount / 1000.0f * (float)FluidInstance.getPlatformBucketFluidAmount());
    }

    public static int getMilliBucketsFluidAmount(long amount) {
        return (int)((float)amount / (float)FluidInstance.getPlatformBucketFluidAmount() * 1000.0f);
    }

    public boolean isFluidEqual(FluidInstance resource) {
        return this.getFluid() == resource.getFluid();
    }

    public void grow(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void shrink(int amount) {
        this.setAmount(this.getAmount() - amount);
    }

    public FluidInstance withAmount(int amount) {
        this.setAmount(amount);
        return this;
    }

    public FluidInstance copy() {
        return new FluidInstance(this.getFluid(), this.getAmount());
    }

    public FluidInstance copyWithAmount(int maxDrain) {
        return this.copy().withAmount(maxDrain);
    }

    public Component getName() {
        return this.getFluid().m_76145_().m_76188_().m_60734_().m_49954_();
    }

    public boolean equals(Object obj) {
        FluidInstance i;
        return super.equals(obj) || obj instanceof FluidInstance && (i = (FluidInstance)obj).isFluidEqual(this) && i.getAmount() == this.getAmount() && Objects.equals(this.tag, i.tag);
    }

    public int hashCode() {
        return Objects.hash(this.fluid, this.amount, this.tag);
    }

    public static void encode(FriendlyByteBuf buf, FluidInstance instance) {
        buf.writeInt(instance.getAmount());
        if (instance.isEmpty()) {
            return;
        }
        buf.m_130085_(BuiltInRegistries.f_257020_.m_7981_((Object)instance.getFluid()));
        buf.m_130079_((Tag)instance.getNonNullTag());
    }

    public static FluidInstance decode(FriendlyByteBuf buf) {
        int amount = buf.readInt();
        if (amount <= 0) {
            return EMPTY;
        }
        return new FluidInstance((Fluid)FactoryAPIPlatform.getRegistryValue(buf.m_130281_(), BuiltInRegistries.f_257020_), amount, buf.m_130260_());
    }
}

