/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.UIAccessor;

public interface UIDefinition
extends Predicate<UIAccessor> {
    public static final UIDefinition EMPTY = new UIDefinition(){};

    default public void beforeInit(UIAccessor accessor) {
        this.getDefinitions().forEach(d -> d.beforeInit(accessor));
    }

    default public void afterInit(UIAccessor accessor) {
        this.getDefinitions().forEach(d -> d.afterInit(accessor));
    }

    default public void beforeTick(UIAccessor accessor) {
        this.getDefinitions().forEach(d -> d.beforeTick(accessor));
    }

    default public void afterTick(UIAccessor accessor) {
        this.getDefinitions().forEach(d -> d.afterTick(accessor));
    }

    default public List<UIDefinition> getDefinitions() {
        return Collections.emptyList();
    }

    public static UIDefinition createBeforeInit(final Consumer<UIAccessor> beforeInit) {
        return new UIDefinition(){

            @Override
            public void beforeInit(UIAccessor accessor) {
                UIDefinition.super.beforeInit(accessor);
                beforeInit.accept(accessor);
            }
        };
    }

    public static UIDefinition createBeforeInit(String name, Consumer<UIAccessor> beforeInit) {
        return UIDefinition.createBeforeInit(a -> {
            if (a.getBoolean(name + ".applyCondition", true).booleanValue()) {
                beforeInit.accept((UIAccessor)a);
            }
        });
    }

    public static UIDefinition createAfterInit(final Consumer<UIAccessor> afterInit) {
        return new UIDefinition(){

            @Override
            public void afterInit(UIAccessor accessor) {
                UIDefinition.super.afterInit(accessor);
                afterInit.accept(accessor);
            }
        };
    }

    public static UIDefinition createAfterInit(String name, Consumer<UIAccessor> afterInit) {
        return UIDefinition.createAfterInit(a -> {
            if (a.getBoolean(name + ".applyCondition", true).booleanValue()) {
                afterInit.accept((UIAccessor)a);
            }
        });
    }

    public static UIDefinition createAfterInitWithAmount(String name, Consumer<UIAccessor> afterInit) {
        return UIDefinition.createAfterInit(a -> {
            Bearer<Integer> bearer = Bearer.of(0);
            a.putBearer(name + ".index", bearer);
            afterInit.accept((UIAccessor)a);
        });
    }

    public static UIDefinition createBeforeTick(final Consumer<UIAccessor> beforeTick) {
        return new UIDefinition(){

            @Override
            public void beforeTick(UIAccessor accessor) {
                UIDefinition.super.beforeTick(accessor);
                beforeTick.accept(accessor);
            }
        };
    }

    public static UIDefinition createAfterTick(final Consumer<UIAccessor> afterTick) {
        return new UIDefinition(){

            @Override
            public void afterTick(UIAccessor accessor) {
                UIDefinition.super.afterTick(accessor);
                afterTick.accept(accessor);
            }
        };
    }

    @Override
    default public boolean test(UIAccessor accessor) {
        return true;
    }
}

