/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryScreenUtil;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin
implements FactoryGuiGraphics.Accessor {
    @Unique
    private int blitColor = -1;
    @Unique
    private boolean depthTest = true;
    @Mutable
    @Shadow
    @Final
    private MultiBufferSource.BufferSource bufferSource;
    @Shadow
    @Final
    private GuiGraphics.ScissorStack scissorStack;
    @Unique
    private MultiBufferSource.BufferSource lastBufferSource;
    @Unique
    private final FactoryGuiGraphics factoryGuiGraphics = new FactoryGuiGraphics(){

        @Override
        public GuiGraphics context() {
            return (GuiGraphics)GuiGraphicsMixin.this;
        }

        @Override
        public void disableDepthTest() {
            FactoryScreenUtil.disableDepthTest();
            GuiGraphicsMixin.this.depthTest = false;
        }

        @Override
        public void enableDepthTest() {
            FactoryScreenUtil.enableDepthTest();
            GuiGraphicsMixin.this.depthTest = true;
        }

        @Override
        public void blit(ResourceLocation texture, int x, int y, int uvX, int uvY, int width, int height) {
            this.context().blit(GuiGraphicsMixin.this.getRenderFunction(), texture, x, y, (float)uvX, (float)uvY, width, height, 256, 256);
        }

        @Override
        public void blit(ResourceLocation texture, int x, int y, int z, float uvX, float uvY, int width, int height, int textureWidth, int textureHeight) {
            this.innerBlit(GuiGraphicsMixin.this.getRenderFunction(), texture, x, x + width, y, y + height, 0, (uvX + 0.0f) / (float)textureWidth, (uvX + (float)width) / (float)textureWidth, (uvY + 0.0f) / (float)textureHeight, (uvY + (float)height) / (float)textureHeight, GuiGraphicsMixin.this.blitColor);
        }

        @Override
        public void blit(ResourceLocation texture, int x, int xd, int y, int yd, float uvX, float uvY, int width, int height, int textureWidth, int textureHeight) {
            this.innerBlit(GuiGraphicsMixin.this.getRenderFunction(), texture, x, xd, y, yd, 0, (uvX + 0.0f) / (float)textureWidth, (uvX + (float)width) / (float)textureWidth, (uvY + 0.0f) / (float)textureHeight, (uvY + (float)height) / (float)textureHeight, GuiGraphicsMixin.this.blitColor);
        }

        @Override
        public void blit(ResourceLocation texture, int x, int y, float uvX, float uvY, int width, int height, int textureWidth, int textureHeight) {
            this.context().blit(GuiGraphicsMixin.this.getRenderFunction(), texture, x, y, uvX, uvY, width, height, textureWidth, textureHeight);
        }

        @Override
        public void blitSprite(ResourceLocation resourceLocation, int x, int y, int width, int height) {
            this.context().blitSprite(GuiGraphicsMixin.this.getRenderFunction(), resourceLocation, x, y, width, height, GuiGraphicsMixin.this.blitColor);
        }

        @Override
        public void blitSprite(ResourceLocation resourceLocation, int x, int y, int z, int width, int height) {
            if (z != 0) {
                this.context().pose().pushPose();
                this.context().pose().translate(0.0f, (float)z, 0.0f);
            }
            this.context().blitSprite(GuiGraphicsMixin.this.getRenderFunction(), resourceLocation, x, y, width, height, GuiGraphicsMixin.this.blitColor);
            if (z != 0) {
                this.context().pose().popPose();
            }
        }

        @Override
        public void blitSprite(ResourceLocation resourceLocation, int textureWidth, int textureHeight, int uvX, int uvY, int x, int y, int z, int width, int height) {
            if (z != 0) {
                this.context().pose().pushPose();
                this.context().pose().translate(0.0f, (float)z, 0.0f);
            }
            this.context().blitSprite(GuiGraphicsMixin.this.getRenderFunction(), resourceLocation, textureWidth, textureHeight, uvX, uvY, x, y, width, height);
            if (z != 0) {
                this.context().pose().popPose();
            }
        }

        @Override
        public void blit(int x, int y, int z, int width, int height, TextureAtlasSprite textureAtlasSprite) {
            if (z != 0) {
                this.context().pose().pushPose();
                this.context().pose().translate(0.0f, (float)z, 0.0f);
            }
            this.context().blitSprite(GuiGraphicsMixin.this.getRenderFunction(), textureAtlasSprite, x, y, width, height);
            if (z != 0) {
                this.context().pose().popPose();
            }
        }

        @Override
        public void enableScissor(int x, int y, int xd, int yd, boolean matrixAffects) {
            if (matrixAffects) {
                Matrix4f matrix4f = this.context().pose().last().pose();
                Vector3f vector3f = matrix4f.transformPosition((float)x, (float)y, 0.0f, new Vector3f());
                Vector3f vector3f2 = matrix4f.transformPosition((float)xd, (float)yd, 0.0f, new Vector3f());
                GuiGraphicsMixin.this.applyScissor(GuiGraphicsMixin.this.scissorStack.push(new ScreenRectangle(Mth.floor((float)vector3f.x), Mth.floor((float)vector3f.y), Mth.floor((float)(vector3f2.x - vector3f.x)), Mth.floor((float)(vector3f2.y - vector3f.y)))));
            } else {
                this.context().enableScissor(x, y, xd, yd);
            }
        }

        @Override
        public void setColor(int color, boolean changeBlend) {
            this.setColor(ColorUtil.getRed(color), ColorUtil.getGreen(color), ColorUtil.getBlue(color), ColorUtil.getAlpha(color), changeBlend);
        }

        @Override
        public void setColor(float r, float g, float b, float a, boolean changeBlend) {
            if (changeBlend) {
                if (a < 1.0f) {
                    FactoryScreenUtil.enableBlend();
                } else {
                    FactoryScreenUtil.disableBlend();
                }
            }
            this.context().flush();
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        }

        @Override
        public float[] getColor() {
            return RenderSystem.getShaderColor();
        }

        @Override
        public void setBlitColor(float r, float g, float b, float a) {
            GuiGraphicsMixin.this.blitColor = ColorUtil.colorFromFloat(r, g, b, a);
        }

        @Override
        public void setBlitColor(int color) {
            GuiGraphicsMixin.this.blitColor = color;
        }

        @Override
        public int getBlitColor() {
            return GuiGraphicsMixin.this.blitColor;
        }

        private void innerBlit(Function<ResourceLocation, RenderType> function, ResourceLocation resourceLocation, int i, int j, int k, int l, int z, float f, float g, float h, float m, int n) {
            RenderType renderType = function.apply(resourceLocation);
            Matrix4f matrix4f = this.context().pose().last().pose();
            VertexConsumer vertexConsumer = this.getBufferSource().getBuffer(renderType);
            vertexConsumer.addVertex(matrix4f, (float)i, (float)k, (float)z).setUv(f, h).setColor(n);
            vertexConsumer.addVertex(matrix4f, (float)i, (float)l, (float)z).setUv(f, m).setColor(n);
            vertexConsumer.addVertex(matrix4f, (float)j, (float)l, (float)z).setUv(g, m).setColor(n);
            vertexConsumer.addVertex(matrix4f, (float)j, (float)k, (float)z).setUv(g, h).setColor(n);
            this.getBufferSource().endBatch(renderType);
        }

        @Override
        public MultiBufferSource.BufferSource getBufferSource() {
            return GuiGraphicsMixin.this.bufferSource;
        }

        @Override
        public void pushBufferSource(MultiBufferSource.BufferSource newBufferSource) {
            GuiGraphicsMixin.this.lastBufferSource = GuiGraphicsMixin.this.bufferSource;
            GuiGraphicsMixin.this.bufferSource = newBufferSource;
        }

        @Override
        public void popBufferSource() {
            if (GuiGraphicsMixin.this.lastBufferSource != null) {
                GuiGraphicsMixin.this.bufferSource = GuiGraphicsMixin.this.lastBufferSource;
            }
        }
    };

    @Unique
    private Function<ResourceLocation, RenderType> getRenderFunction() {
        return this.depthTest ? RenderType::guiTextured : RenderType::guiTexturedOverlay;
    }

    @Shadow
    protected abstract void applyScissor(ScreenRectangle var1);

    @Override
    public FactoryGuiGraphics getFactoryGuiGraphics() {
        return this.factoryGuiGraphics;
    }

    @ModifyArg(method={"blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIIIIIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;IIIIIIIII)V"), index=10)
    public int blitBlitCustom(int par3) {
        return this.blitColor;
    }

    @ModifyArg(method={"blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIIII)V"), index=6)
    public int blitSprite(int par3) {
        return this.blitColor;
    }

    @ModifyArg(method={"blitSprite(Ljava/util/function/Function;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;IIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;IIIII)V"), index=6)
    public int blitSpriteAtlas(int par3) {
        return this.blitColor;
    }

    @ModifyArg(method={"blit(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIFFIIIIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIFFIIIIIII)V"), index=12)
    public int blit(int par3) {
        return this.blitColor;
    }

    @Inject(method={"blitTiledSprite"}, at={@At(value="HEAD")}, cancellable=true)
    public void blitTiledSprite(Function<ResourceLocation, RenderType> function, TextureAtlasSprite textureAtlasSprite, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s, CallbackInfo ci) {
        this.getFactoryGuiGraphics().blitTiledSprite(function, textureAtlasSprite, i, j, s, k, l, m, n, o, p, q, r);
        ci.cancel();
    }
}

