/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.util.ListMap;

public class DynamicUtil {
    public static final ListMap<ResourceLocation, ArbitrarySupplier<ItemStack>> COMMON_ITEMS = new ListMap();
    public static final LoadingCache<Pair<Dynamic<?>, Boolean>, ItemStack> DYNAMIC_ITEMS_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(pair -> ((Dynamic)pair.getFirst()).get("item").asString().result().or(() -> ((Dynamic)pair.getFirst()).asString().result()).map(s -> ((Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.tryParse((String)s))).getDefaultInstance()).map(i -> {
        ((Dynamic)pair.getFirst()).get("count").result().flatMap(d1 -> Codec.INT.parse(d1).result()).ifPresent(arg_0 -> ((ItemStack)i).setCount(arg_0));
        if (((Boolean)pair.getSecond()).booleanValue()) {
            DynamicUtil.convertToRegistryIfPossible((Dynamic)pair.getFirst()).get("components").result().flatMap(d1 -> DataComponentPatch.CODEC.parse(d1).result()).ifPresent(arg_0 -> ((ItemStack)i).applyComponents(arg_0));
        }
        return i;
    }).orElse(ItemStack.EMPTY)));
    public static final LoadingCache<DynamicOps<?>, RegistryOps<?>> REGISTRY_OPS_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(o -> RegistryOps.create((DynamicOps)o, (HolderLookup.Provider)FactoryAPIPlatform.getRegistryAccess())));
    public static final Codec<Vec3> VEC3_OPTIONAL_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.DOUBLE.fieldOf("x").orElse((Object)0.0).forGetter(Vec3::x), (App)Codec.DOUBLE.fieldOf("y").orElse((Object)0.0).forGetter(Vec3::y), (App)Codec.DOUBLE.fieldOf("z").orElse((Object)0.0).forGetter(Vec3::z)).apply((Applicative)i, Vec3::new));
    public static final Codec<Vec3> VEC3_OBJECT_CODEC = Codec.either(VEC3_OPTIONAL_CODEC, (Codec)Vec3.CODEC.fieldOf("value").codec()).xmap(e -> (Vec3)e.map(v -> v, v -> v), Either::right);
    public static final Codec<ItemStack> COMPLETE_ITEM_CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(ItemStack::getItemHolder), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.fieldOf("components").orElse((Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)i, ItemStack::new));
    public static final Codec<ItemStack> ITEM_CODEC = Codec.either((Codec)BuiltInRegistries.ITEM.holderByNameCodec().xmap(ItemStack::new, ItemStack::getItemHolder), COMPLETE_ITEM_CODEC).xmap(e -> e.right().orElseGet(e.left()::get), Either::right);
    public static Codec<ArbitrarySupplier<ItemStack>> ITEM_WITHOUT_DATA_SUPPLIER_CODEC = Codec.of((Encoder)ITEM_CODEC.xmap(ArbitrarySupplier::of, Supplier::get), DynamicUtil::getItemWithoutDataFromDynamic);
    public static Codec<ArbitrarySupplier<ItemStack>> ITEM_SUPPLIER_CODEC = Codec.of((Encoder)ITEM_CODEC.xmap(ArbitrarySupplier::of, Supplier::get), DynamicUtil::getItemFromDynamic);

    public static <T> DataResult<Pair<ArbitrarySupplier<ItemStack>, T>> getItemWithoutDataFromDynamic(DynamicOps<T> ops, T input) {
        return DynamicUtil.getItemFromDynamic(ops, input, false);
    }

    public static <T> DataResult<Pair<ArbitrarySupplier<ItemStack>, T>> getItemFromDynamic(DynamicOps<T> ops, T input) {
        return DynamicUtil.getItemFromDynamic(ops, input, true);
    }

    public static <T> DataResult<Pair<ArbitrarySupplier<ItemStack>, T>> getItemFromDynamic(DynamicOps<T> ops, T input, boolean allowData) {
        return DataResult.success((Object)Pair.of(DynamicUtil.getItemFromDynamic(new Dynamic(ops, input), allowData), input));
    }

    public static ArbitrarySupplier<ItemStack> getItemFromDynamic(Dynamic<?> element, boolean allowData) {
        return element.get("common_item").asString().map(s -> COMMON_ITEMS.get(ResourceLocation.tryParse((String)s))).result().orElseGet(() -> {
            Pair pair = Pair.of((Object)element, (Object)allowData);
            DYNAMIC_ITEMS_CACHE.refresh((Object)pair);
            return () -> (ItemStack)DYNAMIC_ITEMS_CACHE.getUnchecked((Object)pair);
        });
    }

    public static <T> Dynamic<T> convertToRegistryIfPossible(Dynamic<T> dynamic) {
        return !(dynamic.getOps() instanceof RegistryOps) && (!FactoryAPI.isClient() || FactoryAPIClient.hasLevel()) ? dynamic.convert(DynamicUtil.getActualRegistryOps(dynamic.getOps())) : dynamic;
    }

    public static <T> DynamicOps<T> getActualRegistryOps(DynamicOps<T> ops) {
        return FactoryAPI.isClient() && !FactoryAPIClient.hasLevel() ? ops : (DynamicOps)REGISTRY_OPS_CACHE.getUnchecked(ops);
    }

    public static Codec<Component> getComponentCodec() {
        return ComponentSerialization.CODEC;
    }
}

