/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.FactoryFluidHandler;
import wily.factoryapi.base.IPlatformItemFluidHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.init.FactoryRegistries;
import wily.factoryapi.util.CompoundTagUtil;
import wily.factoryapi.util.FluidInstance;

public class FactoryItemFluidHandler
extends FactoryFluidHandler
implements IPlatformItemFluidHandler {
    private final ItemStack container;

    public FactoryItemFluidHandler(int capacity, ItemStack container) {
        this(capacity, container, f -> true, TransportState.EXTRACT_INSERT);
    }

    public FactoryItemFluidHandler(int capacity, ItemStack stack, Predicate<FluidInstance> validator, TransportState transportState) {
        super(capacity, null, validator, SlotsIdentifier.GENERIC, transportState);
        this.container = stack;
    }

    public String getStorageKey() {
        return this.isBlockItem() ? "singleTank" : "Fluid";
    }

    public boolean isBlockItem() {
        return ItemContainerPlatform.isBlockItem(this.container);
    }

    @Override
    public void setFluid(FluidInstance fluid) {
        boolean b = this.isBlockItem();
        if (b) {
            int capacity = this.getMaxFluid();
            CompoundTag beTag = this.container.has(DataComponents.BLOCK_ENTITY_DATA) ? ((TypedEntityData)this.container.get(DataComponents.BLOCK_ENTITY_DATA)).copyTagWithoutId() : new CompoundTag();
            CompoundTag tag = FluidInstance.toTag(fluid);
            tag.putInt("capacity", capacity);
            beTag.put(this.getStorageKey(), (Tag)tag);
            this.container.set(DataComponents.BLOCK_ENTITY_DATA, (Object)TypedEntityData.of((Object)BlockEntityType.CHEST, (CompoundTag)beTag));
        } else {
            this.container.set((DataComponentType)FactoryRegistries.FLUID_INSTANCE_COMPONENT.get(), (Object)fluid);
        }
    }

    @Override
    @NotNull
    public FluidInstance getFluidInstance() {
        return this.isBlockItem() ? FactoryItemFluidHandler.getFromComponentOrDefault(this.container, DataComponents.BLOCK_ENTITY_DATA, TypedEntityData::copyTagWithoutId, c -> FluidInstance.fromTag(CompoundTagUtil.getCompoundTagOrEmpty(c, this.getStorageKey())), c -> c.contains(this.getStorageKey()), FluidInstance.empty()) : (FluidInstance)this.container.getOrDefault((DataComponentType)FactoryRegistries.FLUID_INSTANCE_COMPONENT.get(), (Object)FluidInstance.empty());
    }

    public static <C, D, T> T getFromComponentOrDefault(ItemStack stack, DataComponentType<C> type, Function<C, D> getter, Function<D, T> mapper, Predicate<D> allow, T obj) {
        D d;
        return !stack.has(type) || !allow.test(d = getter.apply(stack.get(type))) ? obj : mapper.apply(d);
    }

    @Override
    public int fill(FluidInstance resource, boolean simulate) {
        if (this.container.getCount() != 1 || resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        FluidInstance contained = this.getFluidInstance().copy();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.getMaxFluid(), resource.getAmount());
            if (!simulate) {
                FluidInstance filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.getMaxFluid() - contained.getAmount(), resource.getAmount());
            if (!simulate && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    @Override
    @NotNull
    public FluidInstance drain(int maxDrain, boolean simulate) {
        if (this.container.getCount() != 1 || maxDrain <= 0 || !this.getTransport().canExtract()) {
            return FluidInstance.empty();
        }
        FluidInstance contained = this.getFluidInstance().copy();
        if (contained.isEmpty()) {
            return FluidInstance.empty();
        }
        int drainAmount = Math.min(contained.getAmount(), maxDrain);
        FluidInstance drained = contained.copy();
        drained.setAmount(drainAmount);
        if (!simulate) {
            contained.shrink(drainAmount);
            if (contained.isEmpty()) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
        return drained;
    }

    protected void setContainerToEmpty() {
        this.container.remove((DataComponentType)FactoryRegistries.FLUID_INSTANCE_COMPONENT.get());
        this.container.remove((DataComponentType)FactoryRegistries.FLUID_CAPACITY_COMPONENT.get());
    }

    @Override
    public void setCapacity(int capacity) {
        boolean b = this.isBlockItem();
        if (b) {
            CompoundTag beTag = this.container.has(DataComponents.BLOCK_ENTITY_DATA) ? ((TypedEntityData)this.container.get(DataComponents.BLOCK_ENTITY_DATA)).copyTagWithoutId() : new CompoundTag();
            CompoundTag tag = CompoundTagUtil.getCompoundTagOrEmpty(beTag, this.getStorageKey());
            tag.putInt("capacity", capacity);
            beTag.put(this.getStorageKey(), (Tag)tag);
            this.container.set(DataComponents.BLOCK_ENTITY_DATA, (Object)TypedEntityData.of((Object)BlockEntityType.CHEST, (CompoundTag)beTag));
        } else {
            this.container.set((DataComponentType)FactoryRegistries.FLUID_CAPACITY_COMPONENT.get(), (Object)capacity);
        }
    }

    @Override
    public int getMaxFluid() {
        return this.isBlockItem() ? FactoryItemFluidHandler.getFromComponentOrDefault(this.container, DataComponents.BLOCK_ENTITY_DATA, TypedEntityData::copyTagWithoutId, c -> CompoundTagUtil.getInt(c, this.getStorageKey()).orElse(0), c -> c.contains(this.getStorageKey()), super.getMaxFluid()).intValue() : ((Integer)this.container.getOrDefault((DataComponentType)FactoryRegistries.FLUID_CAPACITY_COMPONENT.get(), (Object)super.getMaxFluid())).intValue();
    }

    @Override
    public ItemStack getContainer() {
        return this.container;
    }
}

