/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Style;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.ITagSerializable;

public interface IPlatformEnergyStorage
extends ITagSerializable<CompoundTag>,
IPlatformHandler,
EnergyHandler {
    public int receiveEnergy(int var1, boolean var2);

    public int consumeEnergy(int var1, boolean var2);

    public int getEnergyStored();

    public int getMaxEnergyStored();

    default public int getEnergySpace() {
        return Math.max(0, this.getMaxEnergyStored() - this.getEnergyStored());
    }

    public void setEnergyStored(int var1);

    default public int getMaxConsume() {
        return this.getEnergyStored();
    }

    default public int getMaxReceive() {
        return this.getEnergySpace();
    }

    default public Style getComponentStyle() {
        return FactoryAPIPlatform.getPlatformEnergyComponent().getStyle();
    }

    default public long getAmountAsLong() {
        return this.getEnergyStored();
    }

    default public long getCapacityAsLong() {
        return this.getMaxEnergyStored();
    }

    default public int insert(final int i, TransactionContext transactionContext) {
        if (transactionContext instanceof Transaction) {
            Transaction transaction = (Transaction)transactionContext;
            transaction.addCommittingJournal((SnapshotJournal)new SnapshotJournal<Integer>(){

                protected Integer createSnapshot() {
                    return 0;
                }

                protected void revertToSnapshot(Integer object) {
                }

                protected void releaseSnapshot(Integer snapshot) {
                    IPlatformEnergyStorage.this.receiveEnergy(i, false);
                }
            });
        }
        return this.receiveEnergy(i, true);
    }

    default public int extract(final int i, TransactionContext transactionContext) {
        if (transactionContext instanceof Transaction) {
            Transaction transaction = (Transaction)transactionContext;
            transaction.addCommittingJournal((SnapshotJournal)new SnapshotJournal<Integer>(){

                protected Integer createSnapshot() {
                    return 0;
                }

                protected void revertToSnapshot(Integer object) {
                }

                protected void releaseSnapshot(Integer snapshot) {
                    IPlatformEnergyStorage.this.consumeEnergy(i, false);
                }
            });
        }
        return this.consumeEnergy(i, true);
    }
}

