/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.ITagSerializable;

public interface IPlatformItemHandler
extends Container,
ITagSerializable<CompoundTag>,
IPlatformHandler,
ResourceHandler<ItemResource> {
    default public ItemStack removeItemNoUpdate(int i) {
        return this.extractItem(i, this.getItem(i).getCount(), false);
    }

    @Override
    default public void setChanged() {
    }

    default public ItemStack removeItem(int i, int j) {
        return this.extractItem(i, j, false);
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    @NotNull
    public ItemStack getItem(int var1);

    @NotNull
    public ItemStack insertItem(int var1, @NotNull ItemStack var2, boolean var3);

    @NotNull
    public ItemStack extractItem(int var1, int var2, boolean var3);

    default public int size() {
        return this.getContainerSize();
    }

    default public ItemResource getResource(int i) {
        return ItemResource.of((ItemStack)this.getItem(i));
    }

    default public long getAmountAsLong(int i) {
        return this.getItem(i).getCount();
    }

    default public long getCapacityAsLong(int i, ItemResource resource) {
        return this.getMaxStackSize(resource.toStack());
    }

    default public boolean isValid(int i, ItemResource resource) {
        return this.canPlaceItem(i, resource.toStack());
    }

    default public int insert(final int i, ItemResource resource, int j, TransactionContext transactionContext) {
        final ItemStack item = resource.toStack();
        if (transactionContext instanceof Transaction) {
            Transaction transaction = (Transaction)transactionContext;
            transaction.addCommittingJournal((SnapshotJournal)new SnapshotJournal<Integer>(){

                protected Integer createSnapshot() {
                    return 0;
                }

                protected void revertToSnapshot(Integer object) {
                }

                protected void releaseSnapshot(Integer snapshot) {
                    IPlatformItemHandler.this.insertItem(i, item, false);
                }
            });
        }
        return this.insertItem(i, item, true).getCount();
    }

    default public int extract(final int i, ItemResource resource, final int j, TransactionContext transactionContext) {
        if (transactionContext instanceof Transaction) {
            Transaction transaction = (Transaction)transactionContext;
            transaction.addCommittingJournal((SnapshotJournal)new SnapshotJournal<Integer>(){

                protected Integer createSnapshot() {
                    return 0;
                }

                protected void revertToSnapshot(Integer object) {
                }

                protected void releaseSnapshot(Integer snapshot) {
                    IPlatformItemHandler.this.extractItem(i, j, false);
                }
            });
        }
        return this.extractItem(i, j, true).getCount();
    }
}

