/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import wily.factoryapi.base.Bearer;

public class Stocker<T>
implements Bearer<T> {
    private T object;

    public Stocker(T obj) {
        this.object = obj;
    }

    @Override
    public T get() {
        return this.object;
    }

    @Override
    public void set(T obj) {
        this.object = obj;
    }

    public static <T> Stocker<T> of(T obj) {
        return new Stocker<T>(obj);
    }

    public static int cyclic(int min, int i, int max) {
        return i >= max ? min : (i < min ? max - 1 : i);
    }

    public static class Sizeable
    extends Stocker<Integer> {
        public int max = 0;
        public int min = 0;

        public Sizeable(Integer i) {
            super(i);
        }

        public Sizeable(Integer i, int max) {
            super(i);
            this.max = max;
        }

        @Override
        public void set(Integer obj) {
            this.set(obj, false);
        }

        public void set(int i, boolean cyclic) {
            super.set(cyclic ? Sizeable.cyclic(this.min, i, this.max + 1) : Math.max(this.min, Math.min(i, this.max)));
        }

        public int add(int value, boolean cyclic) {
            int oldValue = (Integer)this.get();
            this.set((Integer)this.get() + value, cyclic);
            return (Integer)this.get() - oldValue;
        }

        public int add(int value) {
            return this.add(value, false);
        }

        public int shrink(int value) {
            return this.add(-value);
        }
    }
}

