/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.mixin.base.BakedSheetGlyphAccessor;
import wily.factoryapi.mixin.base.FontAccessor;
import wily.factoryapi.util.FactoryScreenUtil;

public class AdvancedTextWidget
extends SimpleLayoutRenderable
implements GuiEventListener,
NarratableEntry {
    private final UIAccessor accessor;
    private List<FormattedCharSequence> lines = Collections.emptyList();
    private int[] widthPerLine = new int[0];
    private int[] heightPerLine = new int[0];
    private int lineSpacing = 12;
    private boolean centered = false;
    private int color = -1;
    private boolean shadow = true;
    private boolean multipleHeights = true;

    public AdvancedTextWidget(UIAccessor accessor) {
        this.accessor = accessor;
    }

    public AdvancedTextWidget withLines(List<FormattedCharSequence> lines) {
        if (lines != null) {
            this.lines = lines;
            this.processLines();
        }
        return this;
    }

    public void processLines() {
        this.height = 0;
        this.widthPerLine = new int[this.lines.size()];
        this.heightPerLine = new int[this.lines.size()];
        for (int i = 0; i < this.lines.size(); ++i) {
            FormattedCharSequence sequence = this.lines.get(i);
            this.widthPerLine[i] = Minecraft.getInstance().font.width(sequence);
            this.heightPerLine[i] = this.multipleHeights ? Math.max(this.lineSpacing, Math.max(AdvancedTextWidget.getLineHeight(sequence) - 9, 0) + this.lineSpacing) : this.lineSpacing;
            this.height += this.heightPerLine[i];
        }
    }

    public AdvancedTextWidget withLines(Component component, int width) {
        return this.withWidth(width).withLines(Minecraft.getInstance().font.split((FormattedText)component, width));
    }

    public static int getLineHeight(FormattedCharSequence sequence) {
        Bearer<Integer> bearer = Bearer.of(0);
        sequence.accept((n, style, pos) -> {
            FontAccessor fontAccessor = (FontAccessor)Minecraft.getInstance().font;
            BakedGlyph glyph = fontAccessor.getBakedGlyph(pos, style);
            if (glyph instanceof BakedSheetGlyphAccessor) {
                BakedSheetGlyphAccessor sheetGlyph = (BakedSheetGlyphAccessor)glyph;
                int height = Math.round(sheetGlyph.getBottom() - sheetGlyph.getTop());
                if (height > (Integer)bearer.get()) {
                    bearer.set(height);
                }
            } else if (glyph.info().getAdvance() > (float)((Integer)bearer.get()).intValue()) {
                bearer.set(Math.round(glyph.info().getAdvance()));
            }
            return true;
        });
        return (Integer)bearer.get();
    }

    public AdvancedTextWidget lineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        return this;
    }

    public AdvancedTextWidget centered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public AdvancedTextWidget multipleHeights(boolean multipleHeights) {
        this.multipleHeights = multipleHeights;
        return this;
    }

    public AdvancedTextWidget withPos(int x, int y) {
        this.setPosition(x, y);
        return this;
    }

    public AdvancedTextWidget withWidth(int width) {
        this.width = width;
        return this;
    }

    public AdvancedTextWidget withColor(int color) {
        this.color = color;
        return this;
    }

    public AdvancedTextWidget withShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public List<FormattedCharSequence> getLines() {
        return this.lines;
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        int actualHeight = this.getY();
        for (int i1 = 0; i1 < this.lines.size(); ++i1) {
            int lineHeight = this.heightPerLine[i1];
            guiGraphics.drawString(Minecraft.getInstance().font, this.lines.get(i1), this.getX() + (this.centered ? (this.width - this.widthPerLine[i1]) / 2 : 0), actualHeight + (lineHeight - this.lineSpacing) / 2, this.color, this.shadow);
            actualHeight += lineHeight;
        }
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        if (this.handleComponentsClicked(mouseButtonEvent.x(), mouseButtonEvent.y(), mouseButtonEvent.button())) {
            return true;
        }
        return super.mouseClicked(mouseButtonEvent, bl);
    }

    public boolean handleComponentsClicked(double d, double e, int i) {
        if (this.accessor.getScreen() != null && this.isMouseOver(d, e)) {
            if (i == 0) {
                int actualHeight = this.getY();
                for (int i1 = 0; i1 < this.lines.size(); ++i1) {
                    int lineHeight = this.heightPerLine[i1];
                    if (e >= (double)actualHeight && e < (double)(actualHeight + lineHeight)) {
                        this.accessor.getScreen().handleComponentClicked(Minecraft.getInstance().font.getSplitter().componentStyleAtWidth(this.lines.get(i1), Mth.floor((double)(d - (double)this.getX()))));
                        return true;
                    }
                    actualHeight += lineHeight;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isMouseOver(double d, double e) {
        return FactoryScreenUtil.isMouseOver(d, e, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void setFocused(boolean bl) {
    }

    public boolean isFocused() {
        return false;
    }

    public ScreenRectangle getRectangle() {
        return super.getRectangle();
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput arg) {
    }
}

