/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import wily.factoryapi.util.FactoryScreenUtil;

public abstract class SimpleLayoutRenderable
implements Renderable,
LayoutElement {
    public int width;
    public int height;
    public int x;
    public int y;

    public SimpleLayoutRenderable() {
    }

    public SimpleLayoutRenderable(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public static SimpleLayoutRenderable create(final Function<SimpleLayoutRenderable, Renderable> simpleRender) {
        return new SimpleLayoutRenderable(){

            public void render(GuiGraphics guiGraphics, int i, int j, float f) {
                ((Renderable)simpleRender.apply(this)).render(guiGraphics, i, j, f);
            }
        };
    }

    public static SimpleLayoutRenderable create(int width, int height, final Function<SimpleLayoutRenderable, Renderable> simpleRender) {
        return new SimpleLayoutRenderable(width, height){

            public void render(GuiGraphics guiGraphics, int i, int j, float f) {
                ((Renderable)simpleRender.apply(this)).render(guiGraphics, i, j, f);
            }
        };
    }

    public static SimpleLayoutRenderable createDrawString(final Component message, final int xOffset, final int yOffset, int width, int height, final int color, final boolean shadow) {
        return new SimpleLayoutRenderable(width, height){

            public void render(GuiGraphics guiGraphics, int i, int j, float f) {
                guiGraphics.drawString(Minecraft.getInstance().font, message, this.getX() + xOffset, this.getY() + yOffset, color, shadow);
            }
        };
    }

    public void bounds(int x, int y, int width, int height) {
        this.setPosition(x, y);
        this.size(width, height);
    }

    public void size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void init() {
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return FactoryScreenUtil.isMouseOver(mouseX, mouseY, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void setX(int i) {
        this.x = i;
    }

    public void setY(int i) {
        this.y = i;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
    }
}

