/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.network.CommonNetwork;

public class CommonRecipeManager {
    private static final Set<RecipeType<?>> recipeTypesToSync = new HashSet();
    private static Map<RecipeType<?>, Map<ResourceLocation, RecipeHolder<?>>> recipesByType = Collections.emptyMap();

    public static <R extends Recipe<?>> RecipeHolder<R> byId(ResourceLocation id, RecipeType<R> type) {
        return (RecipeHolder)recipesByType.getOrDefault(type, Collections.emptyMap()).get(id);
    }

    public static <R extends Recipe<?>> Collection<RecipeHolder<R>> byType(RecipeType<R> type) {
        return recipesByType.get(type).values();
    }

    public static <R extends Recipe<I>, I extends RecipeInput> Optional<RecipeHolder<R>> getRecipeFor(RecipeType<R> type, I input, Level level) {
        Collection<RecipeHolder<R>> recipes = CommonRecipeManager.byType(type);
        for (RecipeHolder<R> recipe : recipes) {
            if (!recipe.value().matches(input, level)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public static <R extends Recipe<I>, I extends RecipeInput> Optional<ItemStack> getResultFor(RecipeType<R> type, I input, Level level) {
        return CommonRecipeManager.getRecipeFor(type, input, level).map(r -> r.value().assemble(input, (HolderLookup.Provider)level.registryAccess()));
    }

    public static void updateRecipes(RecipeManager manager) {
        recipesByType = manager.getRecipes().stream().collect(Collectors.groupingBy(h -> h.value().getType(), Collectors.toMap(h -> h.id().location(), Function.identity())));
        for (RecipeType<?> recipeType : recipeTypesToSync) {
            ClientPayload.getInstance().syncRecipeTypes.put(recipeType, recipesByType.get(recipeType));
        }
    }

    public static void clearRecipes() {
        recipesByType = Collections.emptyMap();
        ClientPayload.getInstance().syncRecipeTypes.clear();
    }

    public static boolean canSyncType(RecipeType<?> type) {
        return recipeTypesToSync.contains(type);
    }

    public static void addRecipeTypeToSync(RecipeType<?> recipeType) {
        recipeTypesToSync.add(recipeType);
    }

    public record ClientPayload(Map<RecipeType<?>, Map<ResourceLocation, RecipeHolder<?>>> syncRecipeTypes) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<ClientPayload> ID = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("send_client_recipes"), ClientPayload::new);
        private static final ClientPayload instance = new ClientPayload(new HashMap());

        public ClientPayload(CommonNetwork.PlayBuf buf) {
            this(((RegistryFriendlyByteBuf)buf.get()).readMap(b -> (RecipeType)b.readById(arg_0 -> ((Registry)BuiltInRegistries.RECIPE_TYPE).byId(arg_0)), b -> b.readMap(FriendlyByteBuf::readResourceLocation, b1 -> (RecipeHolder)RecipeHolder.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf.get())))));
        }

        public static ClientPayload getInstance() {
            return instance;
        }

        @Override
        public void apply(CommonNetwork.Payload.Context context) {
            recipesByType = this.syncRecipeTypes;
        }

        @Override
        public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
            return ID;
        }

        @Override
        public void encode(CommonNetwork.PlayBuf buf) {
            ((RegistryFriendlyByteBuf)buf.get()).writeMap(this.syncRecipeTypes, (b, t) -> b.writeById(arg_0 -> ((Registry)BuiltInRegistries.RECIPE_TYPE).getId(arg_0), t), (b, t) -> b.writeMap(t, FriendlyByteBuf::writeResourceLocation, (b1, h) -> RecipeHolder.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf.get()), h)));
        }
    }
}

