/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

public class ColorUtil {
    public static int getR(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getG(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getB(int color) {
        return color & 0xFF;
    }

    public static int getA(int color) {
        return color >> 24 & 0xFF;
    }

    public static float getRed(int color) {
        return (float)ColorUtil.getR(color) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)ColorUtil.getG(color) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)ColorUtil.getB(color) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)ColorUtil.getA(color) / 255.0f;
    }

    public static int toInt(float channel) {
        return (int)(channel * 255.0f);
    }

    public static int colorFromInt(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int colorFromFloat(float r, float g, float b, float a) {
        return ColorUtil.colorFromInt(ColorUtil.toInt(r), ColorUtil.toInt(g), ColorUtil.toInt(b), ColorUtil.toInt(a));
    }

    public static int colorFromFloat(float[] rgba) {
        return ColorUtil.colorFromFloat(rgba.length == 0 ? 0.0f : rgba[0], rgba.length <= 1 ? 0.0f : rgba[1], rgba.length <= 2 ? 0.0f : rgba[2], rgba.length <= 3 ? 0.0f : rgba[3]);
    }

    public static float[] rgbaToFloat(int rgba) {
        return new float[]{ColorUtil.getRed(rgba), ColorUtil.getGreen(rgba), ColorUtil.getBlue(rgba), ColorUtil.getAlpha(rgba)};
    }

    public static int withAlpha(int color, int alpha) {
        return ColorUtil.colorFromInt(ColorUtil.getR(color), ColorUtil.getG(color), ColorUtil.getB(color), alpha);
    }

    public static int withAlpha(int color, float alpha) {
        return ColorUtil.colorFromInt(ColorUtil.getR(color), ColorUtil.getG(color), ColorUtil.getB(color), ColorUtil.toInt(alpha));
    }

    public static int mergeColors(int color, int color1) {
        if (color == -1) {
            return color1;
        }
        if (color1 == -1) {
            return color;
        }
        return ColorUtil.colorFromFloat(ColorUtil.getRed(color) * ColorUtil.getRed(color1), ColorUtil.getGreen(color) * ColorUtil.getGreen(color1), ColorUtil.getBlue(color) * ColorUtil.getBlue(color1), ColorUtil.getAlpha(color) * ColorUtil.getAlpha(color1));
    }
}

