/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.FactoryCapacityTier;

public class CraftyTransaction {
    public final int energy;
    @Nullable
    public FactoryCapacityTier tier;
    public static final CraftyTransaction EMPTY = new CraftyTransaction(0, null);

    public CraftyTransaction(int energyTransferred, @Nullable FactoryCapacityTier energyTier) {
        this.energy = energyTransferred;
        this.tier = energyTier;
    }

    public int convertEnergyTo(FactoryCapacityTier tier) {
        return tier == null ? 0 : this.tier.convertEnergyTo(this.energy, tier);
    }

    public CraftyTransaction reduce(float reduction) {
        return new CraftyTransaction(Math.round((float)this.energy / reduction), this.tier);
    }

    public CraftyTransaction min(int energy) {
        return energy < this.energy ? new CraftyTransaction(energy, this.tier) : this;
    }

    public CraftyTransaction max(int energy) {
        return energy > this.energy ? new CraftyTransaction(energy, this.tier) : this;
    }

    public boolean isEmpty() {
        return this.energy == 0 || this.tier == null;
    }
}

