/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.class_2487;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.IModifiableTransportHandler;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.CompoundTagUtil;

public class FactoryEnergyStorage
implements IPlatformEnergyStorage {
    public static final String KEY = "energy";
    protected int energy = 0;
    public int maxOutput;
    public int maxInput;
    protected int capacity;
    class_2586 be;
    protected TransportState transportState;

    public FactoryEnergyStorage(int capacity, @Nullable class_2586 be, TransportState transportState) {
        this.maxOutput = this.maxInput = capacity;
        this.capacity = this.maxInput;
        this.be = be;
        this.transportState = transportState;
    }

    public FactoryEnergyStorage(int capacity, class_2586 be) {
        this(capacity, be, TransportState.EXTRACT_INSERT);
    }

    @Override
    public void method_5431() {
        if (this.be != null) {
            this.be.method_5431();
        }
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public int receiveEnergy(int maxInsert, boolean simulate) {
        if (!this.getTransport().canInsert()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxReceive(), maxInsert);
        if (!simulate && energyReceived != 0) {
            this.energy += energyReceived;
            this.method_5431();
        }
        return energyReceived;
    }

    @Override
    public int consumeEnergy(int maxExtracted, boolean simulate) {
        if (!this.getTransport().canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getMaxConsume(), maxExtracted);
        if (!simulate) {
            this.energy -= energyExtracted;
            this.method_5431();
        }
        return energyExtracted;
    }

    @Override
    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    @Override
    public int getMaxConsume() {
        return Math.min(this.getEnergyStored(), this.maxOutput);
    }

    @Override
    public int getMaxReceive() {
        return Math.min(this.getEnergySpace(), this.maxInput);
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }

    @Override
    public class_2487 serializeTag() {
        class_2487 tag = new class_2487();
        tag.method_10569(KEY, this.energy);
        return tag;
    }

    @Override
    public boolean isRemoved() {
        return this.be.method_11015();
    }

    @Override
    public void deserializeTag(class_2487 nbt) {
        this.setEnergyStored(CompoundTagUtil.getInt(nbt, KEY).orElse(0));
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public static class SidedWrapper
    extends FactoryEnergyStorage
    implements IModifiableTransportHandler {
        private final IPlatformEnergyStorage energyStorage;

        public SidedWrapper(FactoryEnergyStorage energyStorage) {
            super(energyStorage.getMaxEnergyStored(), energyStorage.be, energyStorage.getTransport());
            this.energyStorage = energyStorage;
        }

        @Override
        public int getEnergyStored() {
            return this.energyStorage.getEnergyStored();
        }

        @Override
        public void setEnergyStored(int energy) {
            this.energyStorage.setEnergyStored(energy);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.energyStorage.receiveEnergy(maxReceive, simulate);
        }

        @Override
        public int consumeEnergy(int maxExtract, boolean simulate) {
            return this.energyStorage.consumeEnergy(maxExtract, simulate);
        }

        @Override
        public void setTransport(TransportState state) {
            this.transportState = state;
        }
    }
}

