/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.class_1799;
import net.minecraft.class_2487;
import wily.factoryapi.base.FactoryEnergyStorage;
import wily.factoryapi.base.TransportState;

public class FactoryItemEnergyStorage
extends FactoryEnergyStorage {
    class_1799 container;

    public FactoryItemEnergyStorage(class_1799 stack, int initialEnergy, int capacity, int maxOutput, int maxInput, TransportState transportState) {
        super(capacity, null, transportState);
        this.container = stack;
        if (!stack.method_7948().method_10545("energy")) {
            this.setEnergyStored(initialEnergy);
        }
        this.maxOutput = maxOutput;
        this.maxInput = maxInput;
    }

    public FactoryItemEnergyStorage(class_1799 stack, int capacity, TransportState transportState) {
        this(stack, 0, capacity, capacity, capacity, transportState);
    }

    @Override
    public int receiveEnergy(int receive, boolean simulate) {
        int energyReceived = Math.min(this.getEnergySpace(), Math.min(this.getMaxReceive(), receive));
        int energy = this.getEnergyStored();
        if (!simulate) {
            this.setEnergyStored(energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int consumeEnergy(int consume, boolean simulate) {
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.getMaxConsume(), consume));
        if (!simulate) {
            this.setEnergyStored(energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored() {
        return this.container.method_7948().method_10550("energy");
    }

    @Override
    public void setEnergyStored(int energy) {
        this.container.method_7948().method_10569("energy", energy);
    }

    @Override
    public class_2487 serializeTag() {
        return this.container.method_7948();
    }

    @Override
    public void deserializeTag(class_2487 nbt) {
        this.container.method_7980(nbt);
    }

    @Override
    public int getMaxConsume() {
        return Math.min(this.getEnergyStored(), this.maxOutput);
    }

    @Override
    public int getMaxReceive() {
        return Math.min(this.getMaxEnergyStored(), this.maxInput);
    }
}

