/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import org.apache.commons.lang3.ArrayUtils;
import wily.factoryapi.base.ITagSerializable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.util.CompoundTagUtil;

public class Progress
implements ITagSerializable<class_2487> {
    public Identifier identifier;
    private final List<ProgressEntry> entries;

    public Progress(Identifier identifier, List<ProgressEntry> entries) {
        this.identifier = identifier;
        this.entries = entries;
    }

    public Progress(Identifier identifier) {
        this(identifier, new ArrayList<ProgressEntry>());
    }

    public Progress(Identifier identifier, int x, int y, int initialMaxProgress) {
        this(identifier, List.of(new ProgressEntry(x, y, initialMaxProgress)));
    }

    public Progress(Identifier identifier, int entries, int defaultMaxProgress) {
        this(identifier);
        for (int i = 0; i < entries; ++i) {
            this.add(0, 0, defaultMaxProgress);
        }
    }

    public Progress add(int x, int y, int maxProgress) {
        this.entries.add(new ProgressEntry(x, y, maxProgress));
        return this;
    }

    public List<ProgressEntry> getEntries() {
        return this.entries;
    }

    public ProgressEntry first() {
        return this.get(0);
    }

    public ProgressEntry get(int index) {
        return this.entries.get(index);
    }

    public void forEach(Consumer<ProgressEntry> consumer) {
        this.getEntries().forEach(consumer);
    }

    public void setValues(int[] array) {
        for (int i = 0; i < this.entries.size(); ++i) {
            ProgressEntry p = this.entries.get(i);
            p.set(array[i * 2]);
            p.maxProgress = array[i * 2 + 1];
        }
    }

    public int[] getValues() {
        int[] values = new int[]{};
        for (int i = 0; i < this.entries.size(); ++i) {
            ProgressEntry p = this.entries.get(i);
            values = ArrayUtils.addAll((int[])values, (int[])new int[]{(Integer)p.get(), p.maxProgress});
        }
        return values;
    }

    @Override
    public class_2487 serializeTag() {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10539(this.identifier.name, this.getValues());
        return compoundTag;
    }

    @Override
    public void deserializeTag(class_2487 tag) {
        for (int i = 0; i < this.entries.size(); ++i) {
            ProgressEntry p = this.entries.get(i);
            int[] array = CompoundTagUtil.getIntArrayOrEmpty(tag, this.identifier.name);
            if (i * 2 >= array.length) continue;
            p.set(array[i * 2]);
            p.maxProgress = array[i * 2 + 1];
        }
    }

    public record Identifier(String name) {
        public static Identifier DEFAULT = new Identifier("progress");
        public static Identifier ENERGY_STORAGE = new Identifier("energyStorage");
        public static Identifier TANK = new Identifier("tank");
        public static Identifier BURN_TIME = new Identifier("burnTime");
        public static Identifier GENERATING = new Identifier("gen");
        public static Identifier MATTER = new Identifier("matter");
    }

    public static class ProgressEntry
    extends Stocker<Integer> {
        public int maxProgress;
        public int x;
        public int y;
        public int minValue = 0;

        public ProgressEntry(int x, int y, int maxProgress) {
            super(0);
            this.maxProgress = maxProgress;
            this.x = x;
            this.y = y;
        }

        @Override
        public void set(int value) {
            super.set(Math.max(this.minValue, Math.min(value, this.maxProgress)));
        }

        public int add(int value) {
            int oldValue = (Integer)this.get();
            this.set((Integer)this.get() + value);
            return (Integer)this.get() - oldValue;
        }

        public int shrink(int value) {
            int oldValue = (Integer)this.get();
            this.set((Integer)this.get() - value);
            return oldValue - (Integer)this.get();
        }
    }
}

