/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.GuiSpriteManager;
import wily.factoryapi.base.client.GuiSpriteScaling;

public interface FactoryGuiGraphics {
    public static final Map<class_1058, Map<String, class_2960>> spriteTilesCache = new ConcurrentHashMap<class_1058, Map<String, class_2960>>();

    public class_332 context();

    public class_4597.class_4598 getBufferSource();

    public void pushBufferSource(class_4597.class_4598 var1);

    public void popBufferSource();

    public static FactoryGuiGraphics of(class_332 guiGraphics) {
        return ((Accessor)guiGraphics).getFactoryGuiGraphics();
    }

    public static GuiSpriteManager getSprites() {
        return FactoryAPIClient.sprites;
    }

    public void blit(class_2960 var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public void blit(class_2960 var1, int var2, int var3, int var4, float var5, float var6, int var7, int var8, int var9, int var10);

    public void blit(class_2960 var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9, int var10, int var11);

    public void blit(class_2960 var1, int var2, int var3, float var4, float var5, int var6, int var7, int var8, int var9);

    public void blitSprite(class_2960 var1, int var2, int var3, int var4, int var5);

    public void blitSprite(class_2960 var1, int var2, int var3, int var4, int var5, int var6);

    public void blitSprite(class_2960 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void blit(int var1, int var2, int var3, int var4, int var5, class_1058 var6);

    default public void blitSprite(class_2960 resourceLocation, int textureWidth, int textureHeight, int uvX, int uvY, int x, int y, int width, int height) {
        this.blitSprite(resourceLocation, textureWidth, textureHeight, uvX, uvY, x, y, 0, width, height);
    }

    default public void blitNineSlicedSprite(class_1058 textureAtlasSprite, GuiSpriteScaling.NineSlice nineSlice, int x, int y, int z, int width, int height) {
        GuiSpriteScaling.NineSlice.Border border = nineSlice.border();
        int n = Math.min(border.left(), width / 2);
        int o = Math.min(border.right(), width / 2);
        int p = Math.min(border.top(), height / 2);
        int q = Math.min(border.bottom(), height / 2);
        if (width == nineSlice.width() && height == nineSlice.height()) {
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, x, y, z, width, height);
        } else if (height == nineSlice.height()) {
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, x, y, z, n, height);
            this.blitTiledSprite(textureAtlasSprite, x + n, y, z, width - o - n, height, n, 0, nineSlice.width() - o - n, nineSlice.height(), nineSlice.width(), nineSlice.height());
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, 0, x + width - o, y, z, o, height);
        } else if (width == nineSlice.width()) {
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, x, y, z, width, p);
            this.blitTiledSprite(textureAtlasSprite, x, y + p, z, width, height - q - p, 0, p, nineSlice.width(), nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - q, x, y + height - q, z, width, q);
        } else {
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, 0, x, y, z, n, p);
            this.blitTiledSprite(textureAtlasSprite, x + n, y, z, width - o - n, p, n, 0, nineSlice.width() - o - n, p, nineSlice.width(), nineSlice.height());
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, 0, x + width - o, y, z, o, p);
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), 0, nineSlice.height() - q, x, y + height - q, z, n, q);
            this.blitTiledSprite(textureAtlasSprite, x + n, y + height - q, z, width - o - n, q, n, nineSlice.height() - q, nineSlice.width() - o - n, q, nineSlice.width(), nineSlice.height());
            this.blitSprite(textureAtlasSprite, nineSlice.width(), nineSlice.height(), nineSlice.width() - o, nineSlice.height() - q, x + width - o, y + height - q, z, o, q);
            this.blitTiledSprite(textureAtlasSprite, x, y + p, z, n, height - q - p, 0, p, n, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
            this.blitTiledSprite(textureAtlasSprite, x + n, y + p, z, width - o - n, height - q - p, n, p, nineSlice.width() - o - n, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
            this.blitTiledSprite(textureAtlasSprite, x + width - o, y + p, z, n, height - q - p, nineSlice.width() - o, p, o, nineSlice.height() - q - p, nineSlice.width(), nineSlice.height());
        }
    }

    public void blitSprite(class_1058 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void blitSprite(class_1058 var1, int var2, int var3, int var4, int var5, int var6);

    default public void blitTiledSprite(class_1058 textureAtlasSprite, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s) {
        class_310 minecraft = class_310.method_1551();
        if (l <= 0 || m <= 0) {
            return;
        }
        if (p <= 0 || q <= 0) {
            throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + p + "x" + q);
        }
        class_2960 tile = spriteTilesCache.computeIfAbsent(textureAtlasSprite, sp -> new ConcurrentHashMap()).computeIfAbsent("tile_" + n + "x" + o + "_" + p + "x" + q, string -> {
            try {
                class_1059 atlas = (class_1059)minecraft.method_1531().method_4619(textureAtlasSprite.method_45852());
                Optional<class_2960> opt = AtlasAccessor.of(atlas).getTexturesByName().entrySet().stream().filter(e -> e.getValue() == textureAtlasSprite).findFirst().map(Map.Entry::getKey);
                if (opt.isPresent()) {
                    class_1011 image = class_1011.method_4309((InputStream)minecraft.method_1478().getResourceOrThrow(opt.get().method_45136("textures/gui/sprites/" + opt.get().method_12832() + ".png")).method_14482());
                    int width = (int)Math.ceil((double)(p * image.method_4307()) / (double)r);
                    int height = (int)Math.ceil((double)(q * image.method_4323()) / (double)s);
                    class_1011 tileImage = new class_1011(width, height, false);
                    image.method_47594(tileImage, n * image.method_4307() / r, o * image.method_4323() / s, 0, 0, width, height, false, false);
                    return minecraft.method_1531().method_4617("tile", new class_1043(tileImage));
                }
            }
            catch (IOException e2) {
                FactoryAPI.LOGGER.warn(e2.getMessage());
            }
            return null;
        });
        this.blit(tile, i, j, Math.min(n, p), Math.min(o, q), l, m, p, q);
    }

    public void setColor(int var1, boolean var2);

    public void setColor(float var1, float var2, float var3, float var4, boolean var5);

    default public void setColor(int color) {
        this.setColor(color, false);
    }

    default public void setColor(float r, float g, float b, float a) {
        this.setColor(r, g, b, a, false);
    }

    public float[] getColor();

    default public void clearColor(boolean changeBlend) {
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f, changeBlend);
    }

    default public void clearColor() {
        this.clearColor(false);
    }

    public void disableDepthTest();

    public void enableDepthTest();

    public static interface Accessor {
        public FactoryGuiGraphics getFactoryGuiGraphics();
    }

    public static interface AtlasAccessor {
        public static AtlasAccessor of(class_1059 atlas) {
            return (AtlasAccessor)atlas;
        }

        public Map<class_2960, class_1058> getTexturesByName();
    }
}

