/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.OptionalInt;
import java.util.function.Function;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import wily.factoryapi.base.client.GuiMetadataSection;

public interface GuiSpriteScaling {
    public static final Codec<GuiSpriteScaling> CODEC = Type.CODEC.dispatch(GuiSpriteScaling::type, Type::codec);
    public static final GuiSpriteScaling DEFAULT = new Stretch();

    public Type type();

    public static enum Type implements class_3542
    {
        STRETCH("stretch", Stretch.CODEC),
        TILE("tile", Tile.CODEC),
        NINE_SLICE("nine_slice", NineSlice.CODEC);

        public static final Codec<Type> CODEC;
        private final String key;
        private final Codec<? extends GuiSpriteScaling> codec;

        private Type(String string2, Codec codec) {
            this.key = string2;
            this.codec = codec;
        }

        public String method_15434() {
            return this.key;
        }

        public Codec<? extends GuiSpriteScaling> codec() {
            return this.codec;
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }

    public static class Stretch
    implements GuiSpriteScaling {
        public static final Codec<Stretch> CODEC = Codec.unit(Stretch::new);

        @Override
        public Type type() {
            return Type.STRETCH;
        }
    }

    public record Tile(int width, int height) implements GuiSpriteScaling
    {
        public static final Codec<Tile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33442.fieldOf("width").forGetter(Tile::width), (App)class_5699.field_33442.fieldOf("height").forGetter(Tile::height)).apply((Applicative)instance, Tile::new));

        @Override
        public Type type() {
            return Type.TILE;
        }
    }

    public record NineSlice(int width, int height, Border border) implements GuiSpriteScaling
    {
        public static final Codec<NineSlice> CODEC = GuiMetadataSection.validate(RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33442.fieldOf("width").forGetter(NineSlice::width), (App)class_5699.field_33442.fieldOf("height").forGetter(NineSlice::height), (App)Border.CODEC.fieldOf("border").forGetter(NineSlice::border)).apply((Applicative)instance, NineSlice::new)), NineSlice::validate);

        private static DataResult<NineSlice> validate(NineSlice arg) {
            Border border = arg.border();
            if (border.left() + border.right() >= arg.width()) {
                return DataResult.error(() -> {
                    int var10000 = border.left();
                    return "Nine-sliced texture has no horizontal center slice: " + var10000 + " + " + border.right() + " >= " + arg.width();
                });
            }
            return border.top() + border.bottom() >= arg.height() ? DataResult.error(() -> {
                int var10000 = border.top();
                return "Nine-sliced texture has no vertical center slice: " + var10000 + " + " + border.bottom() + " >= " + arg.height();
            }) : DataResult.success((Object)arg);
        }

        @Override
        public Type type() {
            return Type.NINE_SLICE;
        }

        public record Border(int left, int top, int right, int bottom) {
            private static final Codec<Border> VALUE_CODEC = class_5699.field_33442.flatComapMap(integer -> new Border((int)integer, (int)integer, (int)integer, (int)integer), arg -> {
                OptionalInt optionalInt = arg.unpackValue();
                return optionalInt.isPresent() ? DataResult.success((Object)optionalInt.getAsInt()) : DataResult.error(() -> "Border has different side sizes");
            });
            private static final Codec<Border> RECORD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("left").forGetter(Border::left), (App)class_5699.field_33441.fieldOf("top").forGetter(Border::top), (App)class_5699.field_33441.fieldOf("right").forGetter(Border::right), (App)class_5699.field_33441.fieldOf("bottom").forGetter(Border::bottom)).apply((Applicative)instance, Border::new));
            static final Codec<Border> CODEC = Codec.either(VALUE_CODEC, RECORD_CODEC).xmap(either -> (Border)either.map(Function.identity(), Function.identity()), arg -> arg.unpackValue().isPresent() ? Either.left((Object)arg) : Either.right((Object)arg));

            private OptionalInt unpackValue() {
                return this.left() == this.top() && this.top() == this.right() && this.right() == this.bottom() ? OptionalInt.of(this.left()) : OptionalInt.empty();
            }
        }
    }
}

