/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3283;
import net.minecraft.class_329;
import net.minecraft.class_3300;
import net.minecraft.class_339;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_3802;
import net.minecraft.class_3871;
import net.minecraft.class_3873;
import net.minecraft.class_3874;
import net.minecraft.class_3902;
import net.minecraft.class_3928;
import net.minecraft.class_3979;
import net.minecraft.class_4013;
import net.minecraft.class_404;
import net.minecraft.class_407;
import net.minecraft.class_408;
import net.minecraft.class_410;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_4189;
import net.minecraft.class_420;
import net.minecraft.class_422;
import net.minecraft.class_423;
import net.minecraft.class_424;
import net.minecraft.class_426;
import net.minecraft.class_4286;
import net.minecraft.class_4288;
import net.minecraft.class_429;
import net.minecraft.class_4325;
import net.minecraft.class_433;
import net.minecraft.class_434;
import net.minecraft.class_435;
import net.minecraft.class_436;
import net.minecraft.class_437;
import net.minecraft.class_4381;
import net.minecraft.class_4389;
import net.minecraft.class_4395;
import net.minecraft.class_440;
import net.minecraft.class_442;
import net.minecraft.class_443;
import net.minecraft.class_445;
import net.minecraft.class_446;
import net.minecraft.class_447;
import net.minecraft.class_457;
import net.minecraft.class_458;
import net.minecraft.class_466;
import net.minecraft.class_471;
import net.minecraft.class_472;
import net.minecraft.class_476;
import net.minecraft.class_479;
import net.minecraft.class_480;
import net.minecraft.class_486;
import net.minecraft.class_488;
import net.minecraft.class_489;
import net.minecraft.class_4895;
import net.minecraft.class_490;
import net.minecraft.class_4905;
import net.minecraft.class_494;
import net.minecraft.class_495;
import net.minecraft.class_500;
import net.minecraft.class_524;
import net.minecraft.class_525;
import net.minecraft.class_5250;
import net.minecraft.class_526;
import net.minecraft.class_5375;
import net.minecraft.class_5819;
import net.minecraft.class_6599;
import net.minecraft.class_6777;
import net.minecraft.class_7944;
import net.minecraft.class_8032;
import net.minecraft.class_8219;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.DatapackRepositoryAccessor;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.util.BooleanExpressionEvaluator;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.ExpressionEvaluator;
import wily.factoryapi.util.FactoryItemUtil;
import wily.factoryapi.util.ListMap;
import wily.factoryapi.util.VariableResolver;

public class UIDefinitionManager
implements class_4013 {
    public static final String UI_DEFINITIONS = "ui_definitions";
    public static final ListMap<class_2960, Class<?>> NAMED_UI_TARGETS = new ListMap.Builder<String, Class<class_437>>().put("screen", class_437.class).put("accessibility_onboarding_screen", class_8032.class).put("title_screen", class_442.class).put("options_screen", class_429.class).put("skin_customization_screen", class_440.class).put("video_settings_screen", class_446.class).put("language_select_screen", class_426.class).put("pack_selection_screen", class_5375.class).put("telemetry_info_screen", class_7944.class).put("online_options_screen", class_6777.class).put("sound_options_screen", class_443.class).put("controls_screen", class_458.class).put("mouse_settings_screen", class_4288.class).put("key_binds_screen", class_6599.class).put("chat_options_screen", class_404.class).put("accessibility_options_screen", class_4189.class).put("credits_and_attribution_screen", class_8219.class).put("win_screen", class_445.class).put("confirm_link_screen", class_407.class).put("select_world_screen", class_526.class).put("create_world_screen", class_525.class).put("edit_world_screen", class_524.class).put("join_multiplayer_screen", class_500.class).put("edit_server_screen", class_422.class).put("direct_join_server_screen", class_420.class).put("realms_main_screen", class_4325.class).put("realms_screen", class_4905.class).put("realms_confirm_screen", class_4389.class).put("realms_backup_screen", class_4381.class).put("realms_invite_screen", class_4395.class).put("share_to_lan_screen", class_436.class).put("advancements_screen", class_457.class).put("stats_screen", class_447.class).put("confirm_screen", class_410.class).put("level_loading_screen", class_3928.class).put("progress_screen", class_435.class).put("generic_message_screen", class_424.class).put("receiving_level_screen", class_434.class).put("connect_screen", class_412.class).put("pause_screen", class_433.class).put("inventory_screen", class_490.class).put("crafting_screen", class_479.class).put("container_screen", class_476.class).put("abstract_furnace_screen", class_489.class).put("furnace_screen", class_3873.class).put("smoker_screen", class_3874.class).put("blast_furnace_screen", class_3871.class).put("loom_screen", class_494.class).put("stonecutter_screen", class_3979.class).put("grindstone_screen", class_3802.class).put("enchantment_screen", class_486.class).put("hopper_screen", class_488.class).put("dispenser_screen", class_480.class).put("shulker_box_screen", class_495.class).put("anvil_screen", class_471.class).put("smithing_screen", class_4895.class).put("brewing_stand_screen", class_472.class).put("beacon_screen", class_466.class).put("chat_screen", class_408.class).put("in_bed_chat_screen", class_423.class).put("gui", class_329.class).mapKeys(FactoryAPI::createVanillaLocation).build();
    public static final ListMap<class_2960, Function<class_437, class_437>> DEFAULT_SCREENS_MAP = new ListMap.Builder<String, Function<class_437, class_437>>().put("title", s -> new class_442()).put("options", s -> new class_429(s, class_310.method_1551().field_1690)).put("language_select", s -> new class_426(s, class_310.method_1551().field_1690, class_310.method_1551().method_1526())).put("video_settings", s -> new class_446(s, class_310.method_1551().field_1690)).put("skin_customization", s -> new class_440(s, class_310.method_1551().field_1690)).put("online_options", s -> class_6777.method_47621((class_310)class_310.method_1551(), (class_437)s, (class_315)class_310.method_1551().field_1690)).put("controls", s -> new class_458(s, class_310.method_1551().field_1690)).put("mouse_settings", s -> new class_4288(s, class_310.method_1551().field_1690)).put("key_binds", s -> new class_6599(s, class_310.method_1551().field_1690)).put("chat_options", s -> new class_404(s, class_310.method_1551().field_1690)).put("accessibility_options", s -> new class_4189(s, class_310.method_1551().field_1690)).put("credits_and_attribution", class_8219::new).put("select_world", class_526::new).mapKeys(FactoryAPI::createVanillaLocation).build();
    public final ListMap<class_2960, UIDefinition> map = new ListMap();
    public final List<UIDefinition> staticList = new ArrayList<UIDefinition>();

    public static void registerNamedUITarget(class_2960 id, Class<?> uiClass) {
        NAMED_UI_TARGETS.put(id, uiClass);
    }

    public static void registerNamedUITarget(String path, Class<?> uiClass) {
        UIDefinitionManager.registerNamedUITarget(FactoryAPI.createVanillaLocation(path), uiClass);
    }

    public static void registerDefaultScreen(class_2960 id, Function<class_437, class_437> defaultScreen) {
        DEFAULT_SCREENS_MAP.put(id, defaultScreen);
    }

    public static void registerDefaultScreen(String path, Function<class_437, class_437> defaultScreen) {
        UIDefinitionManager.registerDefaultScreen(FactoryAPI.createVanillaLocation(path), defaultScreen);
    }

    public String method_22322() {
        return "factoryapi:ui_definition_manager";
    }

    public static class_4286 createCheckbox(boolean selected, final BiConsumer<class_4286, Boolean> onPress) {
        return new class_4286(0, 0, 20, 20, (class_2561)class_2561.method_43473(), selected){

            public void method_25306() {
                super.method_25306();
                onPress.accept(this, this.method_20372());
            }
        };
    }

    public static List<Integer> parseIntRange(String s) {
        if (!s.contains(",")) {
            return Collections.singletonList(Integer.parseInt(s));
        }
        String[] numbers = s.split(",");
        ArrayList<Integer> range = new ArrayList<Integer>();
        for (int i = 0; i < numbers.length; ++i) {
            boolean closed = numbers[i].startsWith("[");
            if (closed || numbers[i].startsWith("]")) {
                boolean endClosed;
                int start = Integer.parseInt(numbers[i].substring(1));
                if (!(endClosed = numbers[++i].endsWith("]")) && !numbers[i].endsWith("[")) {
                    FactoryAPI.LOGGER.warn("Incorrect integer interval syntax at ordinal {}, skipping this. \nInteger Range: {}", (Object)(i - 1), (Object)s);
                    continue;
                }
                int end = Integer.parseInt(numbers[i].replace(endClosed ? "]" : "[", ""));
                IntStream.rangeClosed(start + (closed ? 0 : -class_3532.method_17822((double)start)), end + (endClosed ? 0 : -class_3532.method_17822((double)end))).forEach(range::add);
                continue;
            }
            range.add(Integer.parseInt(numbers[i]));
        }
        return range;
    }

    public final void applyStatic(UIAccessor accessor) {
        this.staticList.stream().filter(d -> d.test(accessor)).forEach(accessor.getDefinitions()::add);
    }

    public final void apply(UIAccessor accessor) {
        this.map.values().stream().filter(d -> d.test(accessor)).forEach(accessor.getDefinitions()::add);
    }

    public void method_14491(class_3300 resourceManager) {
        this.map.clear();
        resourceManager.method_14488(UI_DEFINITIONS, r -> r.method_12832().endsWith(".json")).forEach((l, r) -> {
            try (BufferedReader bufferedReader = r.method_43039();){
                Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)class_3518.method_15255((Reader)bufferedReader));
                if (this.map.containsKey(l) && !dynamic.get("replace").asBoolean(false)) {
                    this.map.get(l).getDefinitions().addAll(UIDefinitionManager.fromDynamic(l.toString(), dynamic).getDefinitions());
                } else {
                    this.map.put((class_2960)l, UIDefinitionManager.fromDynamicWithTarget(l.toString(), dynamic));
                }
            }
            catch (IOException exception) {
                FactoryAPI.LOGGER.warn(exception.getMessage());
            }
        });
    }

    public static Class<?> getClassFromString(String uiDefinitionName, String s) {
        try {
            return Class.forName(FactoryAPIPlatform.getCurrentClassName(s));
        }
        catch (ClassNotFoundException e) {
            FactoryAPI.LOGGER.warn("Incorrect Class Name {} from UI Definition {}: {}", (Object)s, (Object)uiDefinitionName, (Object)e.getMessage());
            return null;
        }
    }

    public static <T> UIDefinition fromDynamic(final String name, Dynamic<T> dynamic, final Predicate<UIAccessor> extraCondition) {
        final Optional applyConditionDefinition = dynamic.get("applyCondition").map(d -> ElementType.parseBooleanElement("applyCondition", d)).result();
        UIDefinition uiDefinition = new UIDefinition(){
            final List<UIDefinition> definitions = new ArrayList<UIDefinition>();

            @Override
            public List<UIDefinition> getDefinitions() {
                return this.definitions;
            }

            @Override
            public boolean test(UIAccessor accessor) {
                if (!extraCondition.test(accessor)) {
                    return false;
                }
                applyConditionDefinition.ifPresent(d -> d.beforeInit(accessor));
                return accessor.getBoolean("applyCondition", true);
            }

            public String toString() {
                return name;
            }
        };
        UIDefinitionManager.parseAllElements(uiDefinition, a -> a, dynamic, s -> s);
        return uiDefinition;
    }

    public static <T> UIDefinition fromDynamic(String name, Dynamic<T> dynamic) {
        return UIDefinitionManager.fromDynamic(name, dynamic, a -> true);
    }

    public static <T> UIDefinition fromDynamicWithTarget(String name, Dynamic<T> dynamic) {
        String targetType = dynamic.get("targetType").asString("id");
        Class targetClass = dynamic.get("targetUI").asString().map(s -> targetType.equals("id") ? NAMED_UI_TARGETS.get(class_2960.method_12829((String)s)) : (targetType.equals("class") ? UIDefinitionManager.getClassFromString(name, s) : null)).result().orElse(null);
        class_2561 targetTitle = targetType.equals("screenTitle") ? (class_2561)dynamic.get("targetUI").flatMap(arg_0 -> DynamicUtil.getComponentCodec().parse(arg_0)).result().orElse(null) : null;
        String targetRange = dynamic.get("targetRange").asString("instance");
        return UIDefinitionManager.fromDynamic(name, dynamic, accessor -> accessor.toString().equals(name) || targetClass != null && (targetRange.equals("instance") && targetClass.isInstance(accessor) || targetRange.equals("class") && targetClass == accessor.getClass()) || targetTitle != null && accessor.getScreen() != null && accessor.getScreen().method_25440().equals((Object)targetTitle));
    }

    public static void parseAllElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, Dynamic<?> dynamic, Function<String, String> nameModifier) {
        dynamic.get("elements").asMapOpt(Dynamic::asString, d -> d).result().ifPresentOrElse(m -> m.forEach((s, d) -> UIDefinitionManager.tryParseElement(uiDefinition, accessorFunction, (DataResult<String>)s, d, nameModifier)), () -> dynamic.get("elements").asStream().forEach(d -> UIDefinitionManager.tryParseElement(uiDefinition, accessorFunction, (DataResult<String>)d.get("name").asString(), d, nameModifier)));
    }

    public static void tryParseElement(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, DataResult<String> name, Dynamic<?> dynamic, Function<String, String> nameModifier) {
        name.result().ifPresent(s -> dynamic.get("type").asString().map(ElementType::get).result().ifPresentOrElse(p -> p.parse(uiDefinition, accessorFunction, (String)nameModifier.apply((String)s), dynamic), () -> ArbitrarySupplier.of(ElementType.parseNumberElement((String)nameModifier.apply((String)s), dynamic)).ifPresent(d -> uiDefinition.getDefinitions().add((UIDefinition)d))));
    }

    public void openDefaultScreenAndAddDefinition(Optional<class_2960> defaultScreen, UIDefinition uiDefinition) {
        class_437 s = defaultScreen.map(DEFAULT_SCREENS_MAP::get).orElse(parent -> new class_437((class_2561)class_2561.method_43473()){}).apply(class_310.method_1551().field_1755);
        UIAccessor.of(s).getStaticDefinitions().add(uiDefinition);
        class_310.method_1551().method_1507(s);
    }

    public static interface ElementType {
        public static final ListMap<class_2960, ElementType> map = new ListMap();
        public static final ElementType CHILDREN = ElementType.registerConditional("children", (definition, accessorFunction, name, e) -> UIDefinitionManager.parseAllElements(definition, accessorFunction, e, s -> e.get("applyPrefix").asBoolean(true) ? name + "." + s : s));
        public static final ElementType ADD_BUTTON = ElementType.registerConditional("add_button", (definition, accessorFunction, name, e) -> {
            List<WidgetAction.PressSupplier<class_339>> actions = ElementType.parseActionsElement(definition, name, e);
            ElementType.parseWidgetElements(definition, name, e);
            definition.getDefinitions().add(UIDefinition.createAfterInit(name, a -> a.putWidget(name, ((UIAccessor)accessorFunction.apply(a)).addChild(name, class_4185.method_46430((class_2561)class_2561.method_43473(), b -> actions.forEach(c -> c.press((UIAccessor)a, b, WidgetAction.Type.ENABLE))).method_46431()))));
        });
        public static final ElementType ADD_CHECKBOX = ElementType.registerConditional("add_checkbox", (definition, accessorFunction, name, e) -> {
            List<WidgetAction.PressSupplier<class_339>> actions = ElementType.parseActionsElement(definition, name, e);
            ElementType.parseWidgetElements(definition, name, e);
            ElementType.parseElement(definition, name, e, "selected", (String s, Dynamic<?> d) -> ElementType.parseBooleanElement(s, d));
            definition.getDefinitions().add(UIDefinition.createAfterInit(name, a -> a.putWidget(name, ((UIAccessor)accessorFunction.apply(a)).addChild(name, UIDefinitionManager.createCheckbox(a.getBoolean(name + ".selected"), (c, b) -> actions.forEach(c1 -> c1.press((UIAccessor)a, c, c.method_20372() ? WidgetAction.Type.ENABLE : WidgetAction.Type.DISABLE)))))));
        });
        public static final ElementType ADD_SLIDER = ElementType.registerConditional("add_slider", (definition, accessorFunction, name, e) -> {
            final List entries = e.get("entries").asList(d -> new WidgetAction.CycleEntry((class_2561)d.get("message").flatMap(arg_0 -> DynamicUtil.getComponentCodec().parse(arg_0)).result().orElse(class_2561.method_43473()), ElementType.parseActionsElement(definition, name, d)));
            ElementType.parseElement(definition, name, e, "initialIndex", (String s, Dynamic<?> d) -> ElementType.parseNumberElement(name, s, d));
            ElementType.parseWidgetElements(definition, name, e);
            definition.getDefinitions().add(UIDefinition.createAfterInit(name, a -> a.putWidget(name, ((UIAccessor)accessorFunction.apply(a)).addChild(name, new class_357(0, 0, 200, 20, (class_2561)class_2561.method_43473(), Math.min((double)(entries.size() - 1), (double)a.getInteger(name + "initialIndex", 0) / ((double)entries.size() - 1.0)), (UIAccessor)a){
                WidgetAction.CycleEntry entry;
                final /* synthetic */ UIAccessor val$a;
                {
                    this.val$a = uIAccessor;
                    super(i, j, k, l, component, d);
                    this.entry = this.getActualEntry();
                }

                protected void method_25346() {
                    this.method_25355(this.entry.message());
                }

                private WidgetAction.CycleEntry getActualEntry() {
                    return (WidgetAction.CycleEntry)entries.get((int)((double)(entries.size() - 1) * this.field_22753));
                }

                protected void method_25344() {
                    WidgetAction.CycleEntry oldEntry = this.entry;
                    this.entry = this.getActualEntry();
                    if (!this.entry.equals(oldEntry)) {
                        oldEntry.actions().forEach(action -> action.press(this.val$a, this, WidgetAction.Type.DISABLE));
                        this.entry.actions().forEach(action -> action.press(this.val$a, this, WidgetAction.Type.ENABLE));
                    }
                }
            })).method_25346()));
        });
        public static final ElementType MODIFY_WIDGET = ElementType.registerConditional("modify_widget", ElementType.createIndexable(i -> (definition, accessorFunction, name, e) -> {
            List<WidgetAction.PressSupplier<class_339>> actions = ElementType.parseActionsElement(definition, name, e);
            i.forEach(index -> ElementType.parseWidgetElements(definition, name + (String)(i.size() == 1 ? "" : "_" + index), e));
            definition.getDefinitions().add(UIDefinition.createAfterInit(name, a -> {
                Consumer<class_339> onPressOverride = actions.isEmpty() ? null : w -> actions.forEach(action -> action.press((UIAccessor)a, w, WidgetAction.Type.ENABLE));
                Bearer<Integer> count = Bearer.of(0);
                a.getElements().put(name + ".index", count);
                for (Integer index : i) {
                    class_364 patt0$temp;
                    if (a.getChildren().size() <= index || !((patt0$temp = a.getChildren().get(index)) instanceof class_339)) continue;
                    class_339 w2 = (class_339)patt0$temp;
                    String suffixedName = name + (String)(i.size() == 1 ? "" : "_" + index);
                    if (onPressOverride != null) {
                        a.putStaticElement(suffixedName + ".onPressOverride", onPressOverride);
                    }
                    ((UIAccessor)accessorFunction.apply(a)).putWidget(suffixedName, w2);
                    count.set((Integer)count.get() + 1);
                }
            }));
        }));
        public static final ElementType REMOVE_WIDGET = ElementType.registerConditional("remove_widget", ElementType.createIndexable(i -> (definition, accessorFunction, name, e) -> definition.getDefinitions().add(UIDefinition.createAfterInit(name, a -> {
            for (Integer index : i) {
                if (a.getChildren().size() <= index) continue;
                ((UIAccessor)accessorFunction.apply(a)).removeChild(a.getChildren().get(index));
            }
        }))));
        public static final ElementType PUT_NUMBER = ElementType.registerConditional("put_number", (definition, accessorFunction, name, e) -> ElementType.parseElement(definition, name, e, "value", (String s, Dynamic<?> d) -> ElementType.parseNumberElement(name, d)));
        public static final ElementType PUT_COMPONENT = ElementType.registerConditional("put_component", (definition, accessorFunction, name, e) -> ElementType.parseElement(definition, name, e, "value", (String s, Dynamic<?> d) -> ElementType.parseComponentElement(name, d)));
        public static final ElementType PUT_STRING = ElementType.registerConditional("put_string", (definition, accessorFunction, name, e) -> ElementType.parseElement(definition, name, e, "value", (String s, Dynamic<?> d) -> UIDefinition.createBeforeInit(name, a -> a.putStaticElement(name, d.asString()))));
        public static final ElementType PUT_BOOLEAN = ElementType.registerConditional("put_boolean", (definition, accessorFunction, name, e) -> ElementType.parseElement(definition, name, e, "value", (String s, Dynamic<?> d) -> ElementType.parseBooleanElement(name, d)));
        public static final ElementType PUT_RESOURCE_LOCATION = ElementType.registerConditional("put_resource_location", (definition, accessorFunction, name, e) -> ElementType.parseElement(definition, name, e, "value", (String s, Dynamic<?> d) -> class_2960.field_25139.parse(d).result().map(r -> UIDefinition.createBeforeInit(name, a -> a.putStaticElement(name, r))).orElse(null)));
        public static final ElementType PUT_VEC3 = ElementType.registerConditional("put_vec3", (uiDefinition, accessorFunction, elementName, element) -> DynamicUtil.VEC3_OBJECT_CODEC.parse(element).result().map(c -> UIDefinition.createBeforeInit(elementName, a -> a.putVec3(elementName, (class_243)c))).ifPresent(uiDefinition.getDefinitions()::add));
        public static final ElementType BLIT = ElementType.registerConditional("blit", ElementType::parseBlitElements);
        public static final ElementType BLIT_SPRITE = ElementType.registerConditional("blit_sprite", ElementType::parseBlitSpriteElements);
        public static final ElementType FILL = ElementType.registerConditional("fill", ElementType::parseFillElements);
        public static final ElementType FILL_GRADIENT = ElementType.registerConditional("fill_gradient", ElementType::parseFillGradientElements);
        public static final ElementType DRAW_STRING = ElementType.registerConditional("draw_string", ElementType::parseDrawStringElements);
        public static final ElementType DRAW_MULTILINE_STRING = ElementType.registerConditional("draw_multiline_string", ElementType::parseDrawMultilineStringElements);
        public static final ElementType RENDER_ITEM = ElementType.registerConditional("render_item", ElementType::parseRenderItemElements);
        public static final ElementType RENDER_ITEMS = ElementType.registerConditional("render_items", ElementType::parseRenderItemsElements);
        public static final ElementType COMPARE_ITEMS = ElementType.registerConditional("compare_items", (uiDefinition, accessorFunction, elementName, element) -> {
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseItemStackElement(elementName, s, d), "firstItem", "secondItem");
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseBooleanElement(elementName, s, d), "checkCount");
            uiDefinition.getDefinitions().add(UIDefinition.createBeforeInit(elementName, a -> a.getElements().put(elementName, () -> FactoryItemUtil.compareItems(a.getElementValue(elementName + ".firstItem", null, class_1799.class), a.getElementValue(elementName + ".secondItem", null, class_1799.class), a.getBoolean(elementName + ".checkCount", true)))));
        });
        public static final ElementType CHANCE = ElementType.registerConditional("chance", (uiDefinition, accessorFunction, elementName, element) -> {
            class_5819 rand = class_5819.method_43047();
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "min", "max");
            uiDefinition.getDefinitions().add(UIDefinition.createBeforeInit(elementName, a -> a.getElements().put(elementName, () -> rand.method_43051(a.getInteger(elementName + ".min", 0), a.getInteger(elementName + ".max", 0)))));
        });

        public static void parseWidgetElements(UIDefinition uiDefinition, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "x", "y", "width", "height", "order");
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseComponentElement(elementName, s, d), "message", "tooltip");
            ElementType.parseElement(uiDefinition, elementName, element, "spriteOverride", class_2960.field_25139);
            ElementType.parseElement(uiDefinition, elementName, element, "highlightedSpriteOverride", class_2960.field_25139);
            ElementType.parseElement(uiDefinition, elementName, element, "isVisible", (String s, Dynamic<?> d) -> ElementType.parseBooleanElement(elementName, s, d));
        }

        public static void parseFillElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "x", "y", "width", "height", "color", "order");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.getDefinitions().add(UIDefinition.createAfterInit(elementName, a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> guiGraphics.method_25294(a.getInteger(elementName + ".x", 0), a.getInteger(elementName + ".y", 0), a.getInteger(elementName + ".x", 0) + a.getInteger(elementName + ".width", 0), a.getInteger(elementName + ".y", 0) + a.getInteger(elementName + ".height", 0), a.getInteger(elementName + ".color", -1))))));
        }

        public static void parseFillGradientElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "x", "y", "width", "height", "color", "secondColor", "order");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.getDefinitions().add(UIDefinition.createAfterInit(elementName, a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> guiGraphics.method_25296(a.getInteger(elementName + ".x", 0), a.getInteger(elementName + ".y", 0), a.getInteger(elementName + ".x", 0) + a.getInteger(elementName + ".width", 0), a.getInteger(elementName + ".y", 0) + a.getInteger(elementName + ".height", 0), a.getInteger(elementName + ".color", -1), a.getInteger(elementName + ".secondColor", -1))))));
        }

        public static void parseBlitElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElement(uiDefinition, elementName, element, "texture", class_2960.field_25139);
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "x", "y", "uvX", "uvY", "width", "height", "imageWidth", "imageHeight", "renderColor", "order", "amount");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.getDefinitions().add(UIDefinition.createAfterInitWithAmount(elementName, a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> a.getElement(elementName + ".texture", class_2960.class).ifPresent(t -> FactoryGuiGraphics.of(guiGraphics).blit((class_2960)t, a.getInteger(elementName + ".x", 0), a.getInteger(elementName + ".y", 0), a.getInteger(elementName + ".uvX", 0), a.getInteger(elementName + ".uvY", 0), a.getInteger(elementName + ".width", 0), a.getInteger(elementName + ".height", 0), a.getInteger(elementName + ".imageWidth", 256), a.getInteger(elementName + ".imageHeight", 256)))))));
        }

        public static void parseTranslationElements(UIDefinition uiDefinition, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "translateX", "translateY", "translateZ", "scaleX", "scaleY", "scaleZ");
        }

        public static void parseBlitSpriteElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElement(uiDefinition, elementName, element, "sprite", class_2960.field_25139);
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "x", "y", "width", "height", "renderColor", "order", "amount");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.getDefinitions().add(UIDefinition.createAfterInitWithAmount(elementName, a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> a.getElement(elementName + ".sprite", class_2960.class).ifPresent(t -> FactoryGuiGraphics.of(guiGraphics).blitSprite((class_2960)t, a.getInteger(elementName + ".x", 0), a.getInteger(elementName + ".y", 0), a.getInteger(elementName + ".width", 0), a.getInteger(elementName + ".height", 0)))))));
        }

        public static void parseTextElements(UIDefinition uiDefinition, String elementName, Dynamic<?> element) {
            ElementType.parseElement(uiDefinition, elementName, element, "component", (String s, Dynamic<?> d) -> ElementType.parseComponentElement(elementName, s, d));
            ElementType.parseElement(uiDefinition, elementName, element, "shadow", (String s, Dynamic<?> d) -> ElementType.parseBooleanElement(elementName, s, d));
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "x", "y", "color", "order");
        }

        public static void parseDrawStringElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseTextElements(uiDefinition, elementName, element);
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.getDefinitions().add(UIDefinition.createAfterInit(elementName, a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> a.getElement(elementName + ".component", class_2561.class).ifPresent(c -> guiGraphics.method_51439(class_310.method_1551().field_1772, c, a.getInteger(elementName + ".x", 0), a.getInteger(elementName + ".y", 0), a.getInteger(elementName + ".color", 0xFFFFFF), a.getBoolean(elementName + ".shadow", true).booleanValue()))))));
        }

        public static void parseDrawMultilineStringElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseTextElements(uiDefinition, elementName, element);
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "lineSpacing", "width");
            ElementType.parseElement(uiDefinition, elementName, element, "centered", (String s, Dynamic<?> d) -> ElementType.parseBooleanElement(elementName, s, d));
            uiDefinition.getDefinitions().add(UIDefinition.createAfterInit(elementName, a -> a.getElement(elementName + ".component", class_2561.class).ifPresent(c -> {
                int lineSpacing = a.getInteger(elementName + ".lineSpacing", 12);
                int width = a.getInteger(elementName + ".width", 0);
                AdvancedTextWidget advancedTextWidget = a.putLayoutElement(elementName, ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addChild(elementName, new AdvancedTextWidget((UIAccessor)a).lineSpacing(lineSpacing).withLines((class_2561)c, width).withColor(a.getInteger(elementName + ".color", 0xFFFFFF)).withShadow(a.getBoolean(elementName + ".shadow", true)).centered(a.getBoolean(elementName + ".centered", false))), i -> {}, i -> {});
                a.putStaticElement(elementName + ".linesCount", advancedTextWidget.getLines().size());
            })));
        }

        public static void parseRenderItemsElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseBooleanElement(elementName, s, d), "isFake", "allowDecorations");
            ElementType.parseElement(uiDefinition, elementName, element, "items", (String s, Dynamic<?> d) -> d.asListOpt(d1 -> DynamicUtil.getItemFromDynamic(d1, true)).result().map(l -> UIDefinition.createBeforeInit(elementName, a -> a.putStaticElement((String)s, (class_1799[])l.stream().map(Supplier::get).toArray(class_1799[]::new)))).orElse(null));
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "x", "y", "order");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.getDefinitions().add(UIDefinition.createAfterInit(elementName, a -> {
                UIAccessor accessor = (UIAccessor)accessorFunction.apply((UIAccessor)a);
                Bearer<Integer> index = Bearer.of(0);
                a.putBearer(elementName + ".index", index);
                a.getElement(elementName + ".items", class_1799[].class).ifPresent(stacks -> {
                    accessor.putStaticElement(elementName + ".amount", ((class_1799[])stacks).length);
                    accessor.addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> {
                        class_1799 s = stacks[a.getInteger(elementName + ".index", 0)];
                        int x = a.getInteger(elementName + ".x", 0);
                        int y = a.getInteger(elementName + ".y", 0);
                        if (a.getBoolean(elementName + ".isFake", false).booleanValue()) {
                            guiGraphics.method_51445(s, x, y);
                        } else {
                            guiGraphics.method_51427(s, x, y);
                        }
                        if (a.getBoolean(elementName + ".allowDecorations", true).booleanValue()) {
                            guiGraphics.method_51431(class_310.method_1551().field_1772, s, x, y);
                        }
                    }));
                });
            }));
        }

        public static void parseRenderItemElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseBooleanElement(elementName, s, d), "isFake", "allowDecorations");
            ElementType.parseElement(uiDefinition, elementName, element, "item", (String s, Dynamic<?> d) -> ElementType.parseItemStackElement(elementName, s, d));
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseNumberElement(elementName, s, d), "x", "y", "order", "amount");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.getDefinitions().add(UIDefinition.createAfterInit(elementName, a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> a.getElement(elementName + ".item", class_1799.class).ifPresent(s -> {
                int x = a.getInteger(elementName + ".x", 0);
                int y = a.getInteger(elementName + ".y", 0);
                if (a.getBoolean(elementName + ".isFake", false).booleanValue()) {
                    guiGraphics.method_51445(s, x, y);
                } else {
                    guiGraphics.method_51427(s, x, y);
                }
                if (a.getBoolean(elementName + ".allowDecorations", true).booleanValue()) {
                    guiGraphics.method_51431(class_310.method_1551().field_1772, s, x, y);
                }
            })))));
        }

        public static List<WidgetAction.PressSupplier<class_339>> parseActionsElement(UIDefinition uiDefinition, String elementName, Dynamic<?> element) {
            return element.get("actions").asMapOpt().result().map(m -> m.map(p -> {
                String actionName = elementName + ".actions." + ((Dynamic)p.getFirst()).asString("");
                ElementType.parseElement(uiDefinition, actionName, (Dynamic)p.getSecond(), "applyCondition", (String s, Dynamic<?> d) -> ElementType.parseBooleanElement(elementName, s, d));
                return WidgetAction.CODEC.parse((Dynamic)p.getFirst()).result().flatMap(c -> c.press(a -> a.getBoolean(actionName + ".applyCondition", true), (Dynamic)p.getSecond()));
            }).filter(Optional::isPresent).map(Optional::get).toList()).orElse(Collections.emptyList());
        }

        public static UIDefinition parseItemStackElement(String elementName, Dynamic<?> element) {
            return ElementType.parseItemStackElement(elementName, elementName, element);
        }

        public static UIDefinition parseItemStackElement(String elementName, String field, Dynamic<?> element) {
            ArbitrarySupplier<class_1799> stackSupplier = DynamicUtil.getItemFromDynamic(element, true);
            return UIDefinition.createBeforeInit(elementName, a -> a.getElements().put(field, stackSupplier));
        }

        public static UIDefinition parseNumberElement(String elementName, Dynamic<?> element) {
            return ElementType.parseNumberElement(elementName, elementName, element);
        }

        public static UIDefinition parseNumberElement(String elementName, String field, Dynamic<?> element) {
            Optional numberResult = element.asNumber().result();
            if (numberResult.isPresent()) {
                return numberResult.map(n -> UIDefinition.createBeforeInit(elementName, a -> a.putStaticElement(field, n))).orElse(null);
            }
            return element.asString().map(ExpressionEvaluator::of).map(e -> UIDefinition.createBeforeInit(elementName, a -> a.getElements().put(field, () -> e.evaluate((VariableResolver)a)))).result().orElse(null);
        }

        public static UIDefinition parseBooleanElement(String elementName, Dynamic<?> element) {
            return ElementType.parseBooleanElement(elementName, elementName, element);
        }

        public static <T> UIDefinition parseBooleanElement(String elementName, String field, Dynamic<T> element) {
            Optional booleanResult = element.getOps().getBooleanValue(element.getValue()).result();
            if (booleanResult.isPresent()) {
                return booleanResult.map(n -> UIDefinition.createBeforeInit(elementName, a -> a.putStaticElement(field, n))).orElse(null);
            }
            return element.asString().map(BooleanExpressionEvaluator::of).map(e -> UIDefinition.createBeforeInit(elementName, a -> a.getElements().put(field, () -> e.evaluate((VariableResolver)a)))).result().orElse(null);
        }

        public static UIDefinition parseExternalComponentElement(String elementName, String field, Dynamic<?> element) {
            return element.get("baseDir").flatMap(arg_0 -> ((Codec)class_2960.field_25139).parse(arg_0)).result().map(r -> {
                HashMap componentByLang = new HashMap();
                for (String s : class_310.method_1551().method_1526().method_4665().keySet()) {
                    class_2960 location = r.method_48331("/" + s + ".txt");
                    Optional externalComponent = class_310.method_1551().method_1478().method_14486(location);
                    externalComponent.ifPresent(resource -> {
                        class_5250 c = class_2561.method_43473();
                        try (BufferedReader reader = resource.method_43039();){
                            reader.lines().forEach(l -> {
                                c.method_27693(l);
                                c.method_27693("\n");
                            });
                            componentByLang.put(s, c);
                        }
                        catch (IOException e) {
                            FactoryAPI.LOGGER.warn("Failed to parse {}, this external component won't be loaded.", (Object)location, (Object)e);
                        }
                    });
                }
                return UIDefinition.createBeforeInit(elementName, a -> {
                    block3: {
                        String lang;
                        block2: {
                            lang = class_310.method_1551().method_1526().method_4669();
                            if (componentByLang.containsKey(lang)) break block2;
                            lang = "en_us";
                            if (!componentByLang.containsKey("en_us")) break block3;
                        }
                        a.putComponent(field, (class_2561)componentByLang.get(lang));
                    }
                });
            }).orElse(null);
        }

        public static UIDefinition parseComponentElement(String elementName, String field, Dynamic<?> element) {
            UIDefinition externalComponentUIDefinition = ElementType.parseExternalComponentElement(elementName, field, element);
            if (externalComponentUIDefinition != null) {
                return externalComponentUIDefinition;
            }
            return (element.get("allowVariables").asBoolean(false) ? element.get("translate").flatMap(d -> d.asString().map(s -> UIDefinition.createBeforeInit(a -> a.putComponent(field, (class_2561)class_2561.method_43469((String)s, (Object[])element.get("args").asStream().map(d1 -> d1.asString().result().map(k -> a.getElementValue((String)k, null, Object.class))).filter(Optional::isPresent).map(Optional::get).toArray(Object[]::new)))))) : DynamicUtil.getComponentCodec().parse(element).map(c -> UIDefinition.createBeforeInit(elementName, a -> a.putComponent(field, (class_2561)c)))).result().orElse(null);
        }

        public static UIDefinition parseComponentElement(String elementName, Dynamic<?> element) {
            return ElementType.parseComponentElement(elementName, elementName, element);
        }

        public static void parseElements(UIDefinition uiDefinition, String elementName, Dynamic<?> element, BiFunction<String, Dynamic<?>, UIDefinition> dynamicToDefinition, String ... fields) {
            for (String field : fields) {
                ElementType.parseElement(uiDefinition, elementName, element, field, dynamicToDefinition);
            }
        }

        public static void parseElement(UIDefinition uiDefinition, String elementName, Dynamic<?> element, String field, Codec<?> codec) {
            ElementType.parseElement(uiDefinition, elementName, element, field, (String s, Dynamic<?> d) -> codec.parse(d).result().map(c -> UIDefinition.createBeforeInit(elementName, a -> a.putStaticElement((String)s, c))).orElse(null));
        }

        public static void parseElement(UIDefinition uiDefinition, String elementName, Dynamic<?> element, String field, BiFunction<String, Dynamic<?>, UIDefinition> dynamicToDefinition) {
            element.get(field).result().map(d -> ElementType.parseElementReference(elementName, elementName + "." + field, d).orElseGet(() -> (UIDefinition)dynamicToDefinition.apply(elementName + "." + field, (Dynamic<?>)d))).ifPresent(d -> uiDefinition.getDefinitions().add((UIDefinition)d));
        }

        public static Optional<UIDefinition> parseElementReference(String elementName, String field, Dynamic<?> element) {
            return element.get("reference").asString().result().map(s -> UIDefinition.createBeforeInit(elementName, a -> a.getElements().put(field, () -> a.getElement((String)s).get())));
        }

        public static ElementType get(String id) {
            return ElementType.get(class_2960.method_12829((String)id));
        }

        public static ElementType get(class_2960 id) {
            return map.getOrDefault(id, PUT_NUMBER);
        }

        public static class_2960 getId(ElementType type) {
            return map.getKeyOrDefault(type, null);
        }

        public void parse(UIDefinition var1, Function<UIAccessor, UIAccessor> var2, String var3, Dynamic<?> var4);

        default public void parse(UIDefinition uiDefinition, String elementName, Dynamic<?> element) {
            this.parse(uiDefinition, a -> a, elementName, element);
        }

        public static ElementType createIndexable(Function<List<Integer>, ElementType> parser) {
            return (uiDefinition, accessorFunction, elementName, element) -> ((ElementType)parser.apply(element.get("range").asString().result().map(UIDefinitionManager::parseIntRange).orElse(List.of(Integer.valueOf(element.get("index").asInt(0)))))).parse(uiDefinition, accessorFunction, elementName, element);
        }

        public static ElementType createConditional(ElementType type) {
            return (uiDefinition, accessorFunction, elementName, element) -> {
                ElementType.parseElement(uiDefinition, elementName, element, "applyCondition", (String s, Dynamic<?> d) -> ElementType.parseBooleanElement(elementName, s, d));
                type.parse(uiDefinition, accessorFunction, elementName, element);
            };
        }

        public static ElementType registerConditional(String path, ElementType type) {
            return ElementType.register(FactoryAPI.createVanillaLocation(path), ElementType.createConditional(type));
        }

        public static ElementType register(String path, ElementType type) {
            return ElementType.register(FactoryAPI.createVanillaLocation(path), type);
        }

        public static ElementType register(class_2960 id, ElementType type) {
            map.put(id, type);
            return type;
        }
    }

    public static interface WidgetAction<P, W extends class_339> {
        public static final ListMap<class_2960, WidgetAction<?, class_339>> map = new ListMap.Builder().put("open_default_screen", WidgetAction.create(class_2960.field_25139, s -> (a, w, t) -> class_310.method_1551().method_1507(DEFAULT_SCREENS_MAP.getOrDefault(s, s1 -> null).apply(a.getScreen())))).put("open_config_screen", WidgetAction.create(Codec.STRING, s -> (a, w, t) -> class_310.method_1551().method_1507(FactoryAPIClient.getConfigScreen(FactoryAPIPlatform.getModInfo(s), a.getScreen())))).put("reload_ui", WidgetAction.create(Codec.unit((Object)class_3902.field_17274), s -> (a, w, t) -> a.reloadUI())).put("run_command", WidgetAction.createRunCommand(s -> true)).put("run_windows_command", WidgetAction.createRunCommand(s -> class_156.method_668() == class_156.class_158.field_1133)).put("run_linux_command", WidgetAction.createRunCommand(s -> class_156.method_668() == class_156.class_158.field_1135)).put("run_osx_command", WidgetAction.createRunCommand(s -> class_156.method_668() == class_156.class_158.field_1137)).put("toggle_datapacks", WidgetAction.createToggleDatapacks()).mapKeys(FactoryAPI::createVanillaLocation).build();
        public static final Codec<WidgetAction<?, class_339>> CODEC = map.createCodec((Codec<class_2960>)class_2960.field_25139);

        public Codec<P> getCodec();

        public PressSupplier<W> press(P var1);

        default public Optional<PressSupplier<W>> press(Predicate<UIAccessor> canApply, Dynamic<?> dynamic) {
            return this.getCodec().parse(dynamic).result().or(() -> dynamic.get("value").get().result().flatMap(d -> this.getCodec().parse(d).result())).map(p -> (a, w, type) -> {
                if (canApply.test(a)) {
                    this.press(p).press(a, w, type);
                }
            });
        }

        public static WidgetAction<String, class_339> createRunCommand(Predicate<String> shouldRun) {
            return WidgetAction.create(Codec.STRING, s -> (a, w, t) -> {
                if (shouldRun.test((String)s)) {
                    try {
                        new ProcessBuilder(s.split(" ")).start();
                    }
                    catch (IOException e) {
                        FactoryAPI.LOGGER.warn(e.getMessage());
                    }
                }
            });
        }

        public static WidgetAction<List<String>, class_339> createToggleDatapacks() {
            return WidgetAction.create(Codec.STRING.listOf(), s -> (a, w, t) -> {
                if (a instanceof DatapackRepositoryAccessor) {
                    DatapackRepositoryAccessor datapackAccessor = (DatapackRepositoryAccessor)((Object)a);
                    class_3283 repo = datapackAccessor.getDatapackRepository();
                    switch (t.ordinal()) {
                        case 0: {
                            ArrayList<String> datapacks = new ArrayList<String>((Collection<String>)s);
                            datapacks.removeIf(pack -> !repo.method_29207(pack));
                            Collections.reverse(datapacks);
                            datapacks.addAll(0, repo.method_29210());
                            repo.method_14447(datapacks);
                            datapackAccessor.tryApplyNewDataPacks(repo);
                            break;
                        }
                        case 1: {
                            ArrayList<String> datapacks = new ArrayList<String>(repo.method_29210());
                            datapacks.removeIf(s::contains);
                            repo.method_14447(datapacks);
                            datapackAccessor.tryApplyNewDataPacks(repo);
                        }
                    }
                }
            });
        }

        public static <P, W extends class_339> WidgetAction<P, W> create(final Codec<P> codec, final Function<P, PressSupplier<W>> onPress) {
            return new WidgetAction<P, W>(){

                @Override
                public Codec<P> getCodec() {
                    return codec;
                }

                @Override
                public PressSupplier<W> press(P result) {
                    return (PressSupplier)onPress.apply(result);
                }
            };
        }

        public static interface PressSupplier<W extends class_339> {
            public void press(UIAccessor var1, W var2, Type var3);
        }

        public static enum Type {
            ENABLE,
            DISABLE;

        }

        public record CycleEntry(class_2561 message, List<PressSupplier<class_339>> actions) {
        }
    }
}

