/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_3532;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.config.FactoryCommonOptions;
import wily.factoryapi.util.VariableResolver;

public record ExpressionEvaluator(String expression, List<Token> tokens, Stack<Value> values, Stack<Operator> operators, Bearer<Function> function) {
    public static final LoadingCache<String, ExpressionEvaluator> EXPRESSION_CACHE = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(12L)).build(CacheLoader.from(ExpressionEvaluator::create));
    private static final Pattern TOKEN_PATTERN = Pattern.compile("(\\$\\{[\\dA-Za-z_.-]+})|(:?\\d+\\.?\\d*)|(#[A-Z\\d]+)|([+\\-/*%&|^()]|>>|<<)|(sqrt|cbrt|pow|min|max|clamp)");

    public ExpressionEvaluator(String expression, List<Token> tokens) {
        this(expression, tokens, new Stack<Value>(), new Stack<Operator>(), Bearer.of(null));
    }

    public static ExpressionEvaluator create(String expression) {
        return new ExpressionEvaluator(expression, ExpressionEvaluator.tokenize(expression));
    }

    public static ExpressionEvaluator of(String expression) {
        return (ExpressionEvaluator)EXPRESSION_CACHE.getUnchecked((Object)expression);
    }

    public Number evaluate(VariableResolver variableResolver) {
        this.values.clear();
        this.operators.clear();
        this.function.set(null);
        try {
            for (Token token : this.tokens) {
                token.process(this, variableResolver);
            }
            while (!this.operators.isEmpty()) {
                this.values.push(this.operators.pop().operate(this.values.pop(), this.values.pop()));
            }
            return this.values.pop().value();
        }
        catch (Exception e) {
            if (((Boolean)FactoryCommonOptions.EXPRESSION_FAIL_LOGGING.get()).booleanValue()) {
                FactoryAPI.LOGGER.warn("Incorrect expression syntax: {} \nExpression: {}", (Object)e.getMessage(), (Object)this.toString());
            }
            return 0;
        }
    }

    public static List<Token> tokenize(String expression) {
        Object e;
        Matcher matcher = TOKEN_PATTERN.matcher(expression);
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (matcher.find()) {
            String token;
            if (matcher.group(1) != null) {
                token = matcher.group(1);
                String variableName = token.substring(2, token.length() - 1);
                tokens.add(new Variable(variableName));
                continue;
            }
            if (matcher.group(2) != null) {
                token = matcher.group(2);
                boolean isFallback = token.startsWith(":");
                if (isFallback) {
                    token = token.substring(1);
                }
                tokens.add(token.contains(".") ? Value.of(Double.parseDouble(token), isFallback) : Value.of(Integer.parseInt(token), isFallback));
                continue;
            }
            if (matcher.group(3) != null) {
                long colorValue = Long.parseLong(matcher.group(3).substring(1), 16);
                if (colorValue > Integer.MAX_VALUE) {
                    colorValue -= 0x100000000L;
                }
                tokens.add(Value.of(colorValue));
                continue;
            }
            if (matcher.group(4) != null) {
                tokens.add(new Operator(matcher.group(4)));
                continue;
            }
            if (matcher.group(5) == null) continue;
            tokens.add(Function.of(matcher.group(5)));
        }
        if (!tokens.isEmpty() && (e = tokens.get(0)) instanceof Operator) {
            Operator o = (Operator)e;
            if (o.symbol.equals("-") || o.symbol.equals("+")) {
                tokens.add(0, Value.of(0));
            }
        }
        return tokens;
    }

    public void pushValueOrApplyFunction(Value value) {
        if (this.function.isEmpty()) {
            this.values.push(value);
        } else {
            ((Function)this.function.get()).args.add(value);
            if (((Function)this.function.get()).canEvaluate()) {
                this.values.push(((Function)this.function.get()).tryEvaluate());
                ((Function)this.function.get()).args.clear();
                this.function.set(null);
            }
        }
    }

    public static interface Token {
        public void process(ExpressionEvaluator var1, VariableResolver var2);
    }

    public record Operator(String symbol) implements Token
    {
        public boolean hasPrecedence(Operator second) {
            if (second.symbol().equals("(") || second.symbol().equals(")")) {
                return false;
            }
            return !this.symbol().equals("*") && !this.symbol().equals("/") || !second.symbol().equals("+") && !second.symbol().equals("-");
        }

        public Value operate(Value b, Value a) {
            boolean integers = a.isInteger() && b.isInteger();
            return switch (this.symbol()) {
                case "+" -> {
                    if (integers) {
                        yield Value.of(a.value().intValue() + b.value().intValue());
                    }
                    yield Value.of(a.value().doubleValue() + b.value().doubleValue());
                }
                case "-" -> {
                    if (integers) {
                        yield Value.of(a.value().intValue() - b.value().intValue());
                    }
                    yield Value.of(a.value().doubleValue() - b.value().doubleValue());
                }
                case "*" -> {
                    if (integers) {
                        yield Value.of(a.value().intValue() * b.value().intValue());
                    }
                    yield Value.of(a.value().doubleValue() * b.value().doubleValue());
                }
                case "/" -> {
                    if (b.value().doubleValue() == 0.0) {
                        throw new ArithmeticException("Cannot divide by zero");
                    }
                    if (integers) {
                        yield Value.of(a.value().intValue() / b.value().intValue());
                    }
                    yield Value.of(a.value().doubleValue() / b.value().doubleValue());
                }
                case "%" -> {
                    if (integers) {
                        yield Value.of(a.value().intValue() % b.value().intValue());
                    }
                    yield Value.of(a.value().doubleValue() % b.value().doubleValue());
                }
                case "&" -> Value.of(a.value().intValue() & b.value().intValue());
                case "|" -> Value.of(a.value().intValue() | b.value().intValue());
                case "^" -> Value.of(a.value().intValue() ^ b.value().intValue());
                case ">>" -> Value.of(a.value().intValue() >> b.value().intValue());
                case "<<" -> Value.of(a.value().intValue() << b.value().intValue());
                default -> throw new IllegalArgumentException("Unsupported operator: " + this.symbol());
            };
        }

        @Override
        public void process(ExpressionEvaluator evaluator, VariableResolver variableResolver) {
            if (!this.symbol().equals("(") && !this.symbol().equals(")")) {
                while (!evaluator.operators.isEmpty() && this.hasPrecedence(evaluator.operators.peek())) {
                    evaluator.values.push(evaluator.operators.pop().operate(evaluator.values.pop(), evaluator.values.pop()));
                }
            } else if (this.symbol().equals(")")) {
                while (!evaluator.operators.peek().symbol().equals("(")) {
                    evaluator.values.push(evaluator.operators.pop().operate(evaluator.values.pop(), evaluator.values.pop()));
                }
                evaluator.operators.pop();
                return;
            }
            evaluator.operators.push(this);
        }
    }

    public record Value(Number value, boolean isInteger, boolean isFallback) implements Token
    {
        public static Value of(Number value, boolean isFallback) {
            return new Value(value, value instanceof Integer || value instanceof Long, isFallback);
        }

        public static Value of(Number value) {
            return Value.of(value, false);
        }

        public boolean isValid() {
            return this.value != null;
        }

        @Override
        public void process(ExpressionEvaluator evaluator, VariableResolver variableResolver) {
            if (!this.isFallback() || !evaluator.values.peek().isValid()) {
                if (this.isFallback()) {
                    evaluator.values.pop();
                }
                evaluator.pushValueOrApplyFunction(this);
            }
        }
    }

    public record Variable(String name) implements Token
    {
        @Override
        public void process(ExpressionEvaluator evaluator, VariableResolver variableResolver) {
            evaluator.pushValueOrApplyFunction(Value.of(variableResolver.getNumber(this.name(), null)));
        }
    }

    public record Function(String type, List<Value> args, int argsCount) implements Token
    {
        public static Function of(String type) {
            return new Function(type, new ArrayList<Value>(), Function.argsCountByType(type));
        }

        public static int argsCountByType(String type) {
            return switch (type) {
                case "sqrt", "cbrt" -> 1;
                case "min", "max" -> 2;
                case "clamp" -> 3;
                default -> throw new IllegalArgumentException("Unsupported function: " + type);
            };
        }

        public boolean integers() {
            for (int i = 0; i < this.argsCount; ++i) {
                if (this.args.get(i).isInteger()) continue;
                return false;
            }
            return true;
        }

        public boolean canEvaluate() {
            return this.args.size() >= this.argsCount;
        }

        public Value tryEvaluate() {
            return switch (this.type) {
                case "sqrt" -> Value.of(Math.sqrt(this.args.get(0).value().doubleValue()));
                case "cbrt" -> Value.of(Math.cbrt(this.args.get(0).value().doubleValue()));
                case "pow" -> Value.of(Math.pow(this.args.get(0).value().doubleValue(), this.args.get(1).value().doubleValue()));
                case "min" -> {
                    if (this.integers()) {
                        yield Value.of(Math.min(this.args.get(0).value().intValue(), this.args.get(1).value().intValue()));
                    }
                    yield Value.of(Math.min(this.args.get(0).value().doubleValue(), this.args.get(1).value().doubleValue()));
                }
                case "max" -> {
                    if (this.integers()) {
                        yield Value.of(Math.max(this.args.get(0).value().intValue(), this.args.get(1).value().intValue()));
                    }
                    yield Value.of(Math.max(this.args.get(0).value().doubleValue(), this.args.get(1).value().doubleValue()));
                }
                case "clamp" -> {
                    if (this.integers()) {
                        yield Value.of(class_3532.method_15340((int)this.args.get(0).value().intValue(), (int)this.args.get(1).value().intValue(), (int)this.args.get(2).value().intValue()));
                    }
                    yield Value.of(class_3532.method_15350((double)this.args.get(0).value().doubleValue(), (double)this.args.get(1).value().doubleValue(), (double)this.args.get(2).value().doubleValue()));
                }
                default -> throw new IllegalArgumentException("Unsupported function: " + this.type);
            };
        }

        @Override
        public void process(ExpressionEvaluator evaluator, VariableResolver variableResolver) {
            if (evaluator.function.isPresent()) {
                String message = "Last function with incomplete arguments: %s with %s of %s".formatted(((Function)evaluator.function.get()).type, ((Function)evaluator.function.get()).args.size(), ((Function)evaluator.function.get()).argsCount);
                ((Function)evaluator.function.get()).args.clear();
                evaluator.function.set(this);
                throw new UnsupportedOperationException(message);
            }
            evaluator.function.set(this);
        }
    }
}

