/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.function.Predicate;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.IModifiableTransportHandler;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.FluidInstance;

public class FactoryFluidHandler
implements IPlatformFluidHandler {
    private int capacity;
    private final BlockEntity be;
    public FluidInstance fluid = FluidInstance.empty();
    private final Predicate<FluidInstance> validator;
    private final SlotsIdentifier differential;
    protected TransportState transportState;

    public FactoryFluidHandler(int capacity, BlockEntity be) {
        this(capacity, be, f -> true, SlotsIdentifier.GENERIC, TransportState.EXTRACT_INSERT);
    }

    public FactoryFluidHandler(int capacity, @Nullable BlockEntity be, Predicate<FluidInstance> validator, SlotsIdentifier differential, TransportState transport) {
        this.capacity = capacity;
        this.be = be;
        this.validator = validator;
        this.differential = differential;
        this.transportState = transport;
    }

    @Override
    public boolean isRemoved() {
        return this.be != null && this.be.isRemoved();
    }

    @Override
    public void setChanged() {
        if (this.be != null) {
            this.be.setChanged();
        }
    }

    @Override
    @NotNull
    public FluidInstance getFluidInstance() {
        return this.fluid;
    }

    @Override
    public int getMaxFluid() {
        return this.capacity;
    }

    @Override
    public boolean isFluidValid(@NotNull FluidInstance instance) {
        return this.validator.test(instance);
    }

    @Override
    public int fill(FluidInstance resource, boolean simulate) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (simulate) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.getMaxFluid(), resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.getMaxFluid() - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = FluidInstance.create(resource, Math.min(this.getMaxFluid(), resource.getAmount()));
            this.setChanged();
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.getMaxFluid() - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.getMaxFluid());
        }
        if (filled > 0) {
            this.setChanged();
        }
        return filled;
    }

    @Override
    @NotNull
    public FluidInstance drain(FluidInstance resource, boolean simulate) {
        if (!resource.isFluidEqual(this.getFluidInstance())) {
            return FluidInstance.empty();
        }
        return this.drain(resource.getAmount(), simulate);
    }

    @Override
    @NotNull
    public FluidInstance drain(int maxDrain, boolean simulate) {
        if (!this.getTransport().canExtract()) {
            return FluidInstance.empty();
        }
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidInstance stack = FluidInstance.create(this.fluid, drained);
        if (!simulate && drained > 0) {
            this.fluid.shrink(drained);
            this.setChanged();
        }
        return stack;
    }

    @Override
    public void setFluid(FluidInstance FluidInstance2) {
        this.fluid = FluidInstance2;
    }

    @Override
    public SlotsIdentifier identifier() {
        return this.differential;
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public static class SidedWrapper
    extends FactoryFluidHandler
    implements IModifiableTransportHandler {
        private final IPlatformFluidHandler fluidHandler;

        public SidedWrapper(IPlatformFluidHandler fluidHandler) {
            super(fluidHandler.getMaxFluid(), ((FactoryFluidHandler)fluidHandler).be, fluidHandler::isFluidValid, fluidHandler.identifier(), fluidHandler.getTransport());
            this.fluidHandler = fluidHandler;
        }

        @Override
        @NotNull
        public FluidInstance drain(int maxDrain, boolean simulate) {
            return this.fluidHandler.drain(maxDrain, simulate);
        }

        @Override
        public int fill(FluidInstance fluid, boolean simulate) {
            return this.fluidHandler.fill(fluid, simulate);
        }

        @Override
        public FluidInstance getFluidInstance() {
            return this.fluidHandler.getFluidInstance();
        }

        @Override
        public void setFluid(FluidInstance stack) {
            this.fluidHandler.setFluid(stack);
        }

        @Override
        public void setTransport(TransportState state) {
            this.transportState = state;
        }
    }
}

