/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Collections;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.mixin.base.FuelValuesAccessor;

public class FuelManager {
    public static int getBurnTime(Item item) {
        return FuelManager.getBurnTime(item.getDefaultInstance());
    }

    public static Map<Item, Integer> getMap() {
        FuelValues fuelValues = FuelManager.getFuelValues();
        return fuelValues == null ? Collections.emptyMap() : ((FuelValuesAccessor)fuelValues).getValues();
    }

    public static FuelValues getFuelValues() {
        return FactoryAPI.currentServer == null ? (FactoryAPIClient.hasLevel() ? FactoryAPIClient.getLevel().fuelValues() : null) : FactoryAPI.currentServer.fuelValues();
    }

    public static int getBurnTime(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        FuelValues fuelValues = FuelManager.getFuelValues();
        int ret = stack.getBurnTime(null);
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret == -1 ? (fuelValues == null ? 0 : fuelValues.burnDuration(stack)) : ret), null);
    }

    public static boolean isFuel(Item item) {
        return FuelManager.getBurnTime(item) > 0;
    }

    public static boolean isFuel(ItemStack stack) {
        return FuelManager.isFuel(stack.getItem());
    }

    public static void add(Item item, int burnTime) {
        FurnaceFuelBurnTimeEvent.BUS.addListener(e -> {
            if (e.getItemStack().is(item)) {
                e.setBurnTime(burnTime);
            }
        });
    }
}

