/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1863;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_374;
import net.minecraft.class_3887;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_4608;
import net.minecraft.class_5455;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_746;
import net.minecraft.class_773;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_9779;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.FactoryExtraMenuSupplier;
import wily.factoryapi.base.IFactoryItem;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.IFactoryItemClientExtension;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinitionManager;
import wily.factoryapi.base.client.screen.FactoryConfigScreen;
import wily.factoryapi.base.compat.client.FactoryAPIModMenuCompat;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.base.network.HelloPayload;
import wily.factoryapi.base.network.OpenExtraMenuPayload;
import wily.factoryapi.base.network.SecureExecutor;
import wily.factoryapi.mixin.base.MenuScreensAccessor;
import wily.factoryapi.mixin.base.MenuTypeAccessor;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.FluidInstance;
import wily.factoryapi.util.ModInfo;

public class FactoryAPIClient {
    public static final class_2960 BLOCK_ATLAS = FactoryAPI.createVanillaLocation("textures/atlas/blocks.png");
    public static final class_2960 BLOCK_ATLAS_ID = FactoryAPI.createVanillaLocation("blocks");
    public static final SecureExecutor SECURE_EXECUTOR = new SecureExecutor(){

        @Override
        public boolean isSecure() {
            return class_310.method_1551().field_1724 != null;
        }
    };
    private static final Map<String, Function<class_437, class_437>> defaultConfigScreens = new HashMap<String, Function<class_437, class_437>>();
    public static UIDefinitionManager uiDefinitionManager;
    public static final Map<class_2960, ExtraModelId> extraModels;
    private static final Set<String> playerMods;
    public static final FactoryEvent<Consumer<class_310>> STOPPING;
    public static final FactoryEvent<Consumer<class_310>> RESIZE_DISPLAY;

    public static class_9779 getDeltaTracker() {
        return class_310.method_1551().method_60646();
    }

    public static class_1087 getExtraModel(class_2960 resourceLocation) {
        return class_310.method_1551().method_1554().method_4742(extraModels.get(resourceLocation).modelId());
    }

    public static boolean hasAPIOnServer() {
        return FactoryAPIClient.hasModOnServer("factory_api");
    }

    public static boolean hasModOnServer(String id) {
        return playerMods.contains(id);
    }

    public static boolean hasLevel() {
        return class_310.method_1551().field_1687 != null;
    }

    public static class_5455 getRegistryAccess() {
        return class_310.method_1551().field_1687.method_30349();
    }

    public static class_3695 getProfiler() {
        return class_310.method_1551().method_16011();
    }

    public static class_374 getToasts() {
        return class_310.method_1551().method_1566();
    }

    public static float getPartialTick() {
        return FactoryAPIClient.getDeltaTracker().method_60638();
    }

    public static float getGamePartialTick(boolean allowFrozen) {
        return FactoryAPIClient.getDeltaTracker().method_60637(!allowFrozen);
    }

    public static class_1863 getRecipeManager() {
        return class_310.method_1551().field_1687.method_8433();
    }

    public static class_1937 getLevel() {
        return class_310.method_1551().field_1687;
    }

    public static long getWindow() {
        return class_310.method_1551().method_22683().method_4490();
    }

    public static void init() {
        FactoryAPIClient.registerConfigScreen(FactoryAPIPlatform.getModInfo("factory_api"), FactoryConfigScreen::createFactoryAPIConfigScreen);
        uiDefinitionManager = new UIDefinitionManager();
        FactoryEvent.registerReloadListener(class_3264.field_14188, (class_3302)uiDefinitionManager);
        FactoryAPIClient.setup(m -> FactoryOptions.CLIENT_STORAGE.load());
        FactoryAPIClient.preTick(m -> SECURE_EXECUTOR.executeAll());
        FactoryGuiElement.HOTBAR.post().register(graphics -> UIAccessor.of(class_310.method_1551().field_1705).getChildrenRenderables().forEach(r -> r.method_25394(graphics, 0, 0, FactoryAPIClient.getPartialTick())));
        PlayerEvent.JOIN_EVENT.register(l -> {
            DynamicUtil.REGISTRY_OPS_CACHE.invalidateAll();
            DynamicUtil.DYNAMIC_ITEMS_CACHE.asMap().keySet().forEach(arg_0 -> DynamicUtil.DYNAMIC_ITEMS_CACHE.refresh(arg_0));
        });
        PlayerEvent.DISCONNECTED_EVENT.register(l -> {
            DynamicUtil.REGISTRY_OPS_CACHE.invalidateAll();
            DynamicUtil.DYNAMIC_ITEMS_CACHE.asMap().keySet().forEach(arg_0 -> DynamicUtil.DYNAMIC_ITEMS_CACHE.refresh(arg_0));
            if (FactoryAPIClient.hasAPIOnServer()) {
                FactoryConfig.COMMON_STORAGES.values().forEach(c -> {
                    if (c.isServerOnly()) {
                        c.reset();
                    } else if (c.allowSync()) {
                        c.load();
                    }
                });
            }
            playerMods.clear();
        });
        IFactoryItemClientExtension.map.forEach((i, c) -> ArmorRenderer.register((matrices, vertexConsumers, stack, entity, slot, light, contextModel) -> c.getHumanoidArmorModel(entity, stack, slot, contextModel).method_60879(matrices, vertexConsumers.getBuffer(class_1921.method_23576((class_2960)((IFactoryItem)i).getArmorLocation(stack, (class_1297)entity, slot))), light, class_4608.field_21444), (class_1935[])new class_1935[]{i}));
        if (FactoryAPI.isModLoaded("modmenu")) {
            FactoryAPIModMenuCompat.init();
        }
    }

    public static <T extends CommonNetwork.Payload> void registerPayload(CommonNetwork.Identifier<T> id) {
        ClientPlayNetworking.registerGlobalReceiver(id.type(), (payload, context) -> payload.applyClient());
    }

    public static <T extends class_1703> void handleExtraMenu(SecureExecutor executor, class_1657 player, class_3917<T> menuType, OpenExtraMenuPayload payload) {
        class_1703 menu;
        Object object;
        class_3917.class_3918<?> class_39182 = ((MenuTypeAccessor)menuType).getConstructor();
        if (class_39182 instanceof FactoryExtraMenuSupplier) {
            FactoryExtraMenuSupplier supplier = (FactoryExtraMenuSupplier)class_39182;
            object = supplier.create(payload.menuId(), player.method_31548(), payload.extra());
        } else {
            object = menuType.method_17434(payload.menuId(), player.method_31548());
        }
        player.field_7512 = menu = object;
        executor.execute(() -> class_310.method_1551().method_1507(MenuScreensAccessor.getConstructor(menuType).create(menu, player.method_31548(), payload.component())));
    }

    public static void setup(Consumer<class_310> listener) {
        ClientLifecycleEvents.CLIENT_STARTED.register(listener::accept);
    }

    public static void preTick(Consumer<class_310> listener) {
        ClientTickEvents.START_CLIENT_TICK.register(listener::accept);
    }

    public static void postTick(Consumer<class_310> listener) {
        ClientTickEvents.END_CLIENT_TICK.register(listener::accept);
    }

    public static class_1058 getFluidStillTexture(class_3611 fluid) {
        return FluidVariantRendering.getSprite((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    public static class_1058 getFluidFlowingTexture(class_3611 fluid) {
        return FluidVariantRendering.getSprites((FluidVariant)FluidVariant.of((class_3611)fluid))[1];
    }

    public static int getFluidColor(class_3611 fluid, class_1920 view, class_2338 pos) {
        return FluidVariantRendering.getColor((FluidVariant)FluidVariant.of((class_3611)fluid), (class_1920)view, (class_2338)pos);
    }

    public static int getFluidColor(FluidInstance fluid) {
        return FluidVariantRendering.getColor((FluidVariant)fluid.toVariant(), null, null);
    }

    public static void registerKeyMapping(Consumer<Consumer<class_304>> registry) {
        registry.accept(KeyBindingHelper::registerKeyBinding);
    }

    public static class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    public static class_437 getConfigScreen(ModInfo mod, class_437 screen) {
        if (defaultConfigScreens.containsKey(mod.getId())) {
            return defaultConfigScreens.get(mod.getId()).apply(screen);
        }
        return FactoryAPI.isModLoaded("modmenu") ? FactoryAPIModMenuCompat.getConfigScreen(mod.getId(), screen) : null;
    }

    public static void registerDefaultConfigScreen(String modId, Function<class_437, class_437> configScreenFactory) {
        defaultConfigScreens.put(modId, configScreenFactory);
    }

    public static void registerConfigScreen(ModInfo mod, Function<class_437, class_437> configScreenFactory) {
        FactoryAPIClient.registerDefaultConfigScreen(mod.getId(), configScreenFactory);
        if (FactoryAPI.isModLoaded("modmenu")) {
            FactoryAPIClient.setup(m -> FactoryAPIModMenuCompat.registerConfigScreen(mod.getId(), configScreenFactory));
        }
    }

    public static void registerMenuScreen(Consumer<MenuScreenRegister> registry) {
        registry.accept(class_3929::method_17542);
    }

    public static void registerBlockColor(Consumer<BiConsumer<class_322, class_2248>> registry) {
        registry.accept((x$0, xva$1) -> ColorProviderRegistry.BLOCK.register(x$0, (Object[])new class_2248[]{xva$1}));
    }

    public static void registerItemColor(Consumer<BiConsumer<class_326, class_1792>> registry) {
        registry.accept((x$0, xva$1) -> ColorProviderRegistry.ITEM.register(x$0, (Object[])new class_1935[]{xva$1}));
    }

    public static void registerRenderType(class_1921 renderType, class_2248 ... blocks) {
        BlockRenderLayerMap.INSTANCE.putBlocks(renderType, blocks);
    }

    public static void registerRenderType(class_1921 renderType, class_3611 ... fluids) {
        BlockRenderLayerMap.INSTANCE.putFluids(renderType, fluids);
    }

    public static void registerExtraModels(Consumer<Consumer<class_2960>> registry) {
        registry.accept(id -> extraModels.put((class_2960)id, ExtraModelId.create(id)));
    }

    public static <T extends class_1297> void registerEntityRenderer(Supplier<? extends class_1299<? extends T>> type, class_5617<T> provider) {
        EntityRendererRegistry.register(type.get(), provider);
    }

    public static void registerLayerDefinition(class_5601 location, Supplier<class_5607> definition) {
        EntityModelLayerRegistry.registerModelLayer((class_5601)location, definition::get);
    }

    public static void registerRenderLayer(Consumer<FactoryRenderLayerRegistry> registry) {
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((a, b, c, d) -> registry.accept(new FactoryRenderLayerRegistry(){

            @Override
            public class_897<?> getEntityRenderer(class_1299<? extends class_1309> entityType) {
                return b;
            }

            @Override
            public class_5599 getEntityModelSet() {
                return d.method_32170();
            }

            @Override
            public <T extends class_1309, M extends class_583<T>> void register(class_922<T, M> renderer, class_3887<T, M> renderLayer) {
                c.register(renderLayer);
            }
        }));
    }

    public static void handleHelloPayload(HelloPayload payload) {
        playerMods.addAll(payload.modIds());
    }

    static {
        extraModels = new HashMap<class_2960, ExtraModelId>();
        playerMods = new HashSet<String>();
        STOPPING = new FactoryEvent<Consumer>(e -> m -> e.invokeAll(l -> l.accept(m)));
        RESIZE_DISPLAY = new FactoryEvent<Consumer>(e -> m -> e.invokeAll(l -> l.accept(m)));
    }

    public record ExtraModelId(class_2689<class_2248, class_2680> stateDefinition, class_2680 blockState, class_2960 id, class_1091 modelId) {
        public static ExtraModelId create(class_2960 id) {
            class_2689 stateDefinition = new class_2689.class_2690((Object)class_2246.field_10124).method_11668(class_2248::method_9564, class_2680::new);
            return new ExtraModelId((class_2689<class_2248, class_2680>)stateDefinition, (class_2680)stateDefinition.method_11664(), id, class_773.method_3336((class_2960)id, (class_2680)((class_2680)stateDefinition.method_11664())));
        }
    }

    public static interface PlayerEvent
    extends Consumer<class_746> {
        public static final FactoryEvent<PlayerEvent> JOIN_EVENT = new FactoryEvent<PlayerEvent>(e -> s -> e.invokeAll(t -> t.accept(s)));
        public static final FactoryEvent<PlayerEvent> DISCONNECTED_EVENT = new FactoryEvent<PlayerEvent>(e -> s -> e.invokeAll(t -> t.accept(s)));
    }

    public static interface MenuScreenRegister {
        public <H extends class_1703, S extends class_437> void register(class_3917<? extends H> var1, class_3929.class_3930<H, S> var2);
    }

    public static interface FactoryRenderLayerRegistry {
        public class_897<?> getEntityRenderer(class_1299<? extends class_1309> var1);

        public class_5599 getEntityModelSet();

        public <T extends class_1309, M extends class_583<T>> void register(class_922<T, M> var1, class_3887<T, M> var2);
    }
}

