/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9331;
import wily.factoryapi.base.CraftyTransaction;
import wily.factoryapi.base.FactoryCapacityTier;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.init.FactoryRegistries;

public class SimpleItemCraftyStorage
implements ICraftyEnergyStorage {
    private static final String KEY = "energy";
    private int capacity;
    private final int maxOutput;
    private final int maxInput;
    class_1799 container;
    TransportState transportState;
    final boolean isBlockItem;
    public final FactoryCapacityTier supportableTier;
    public FactoryCapacityTier storedTier = FactoryCapacityTier.BASIC;

    public SimpleItemCraftyStorage(class_1799 stack, int initialEnergy, int capacity, int maxOutput, int maxInput, TransportState transportState, FactoryCapacityTier supportableTier, boolean isBlockItem) {
        this.supportableTier = supportableTier;
        this.isBlockItem = isBlockItem;
        this.capacity = capacity;
        this.container = stack;
        this.transportState = transportState;
        this.maxOutput = maxOutput;
        this.maxInput = maxInput;
    }

    public SimpleItemCraftyStorage(class_1799 stack, int capacity, TransportState transportState, FactoryCapacityTier supportableTier) {
        this(stack, 0, capacity, capacity, capacity, transportState, supportableTier, stack.method_7909() instanceof class_1747);
    }

    @Override
    public CraftyTransaction receiveEnergy(CraftyTransaction transaction, boolean simulate) {
        if (transaction.isEmpty()) {
            return CraftyTransaction.EMPTY;
        }
        int energyReceived = Math.min(this.getMaxReceive(), transaction.energy);
        int energy = this.getEnergyStored();
        if (!simulate) {
            if (!this.supportableTier.supportTier(transaction.tier)) {
                return CraftyTransaction.EMPTY;
            }
            this.setStoredTier(transaction.tier);
            this.setEnergyStored(energy += energyReceived);
        }
        return new CraftyTransaction(energyReceived, transaction.tier);
    }

    @Override
    public CraftyTransaction consumeEnergy(CraftyTransaction transaction, boolean simulate) {
        if (transaction.isEmpty()) {
            return CraftyTransaction.EMPTY;
        }
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.getMaxConsume(), transaction.energy));
        if (!simulate) {
            if (!this.storedTier.supportTier(transaction.tier)) {
                energyExtracted = this.storedTier.convertEnergyTo(energyExtracted, transaction.tier);
            }
            this.setEnergyStored(energy -= energyExtracted);
        }
        return new CraftyTransaction(energyExtracted, transaction.tier);
    }

    @Override
    public FactoryCapacityTier getSupportedTier() {
        return (FactoryCapacityTier)((Object)this.container.method_57825((class_9331)FactoryRegistries.ENERGY_TIER_COMPONENT.get(), (Object)this.supportableTier));
    }

    @Override
    public FactoryCapacityTier getStoredTier() {
        return (FactoryCapacityTier)((Object)this.container.method_57825((class_9331)FactoryRegistries.STORED_ENERGY_TIER_COMPONENT.get(), (Object)FactoryCapacityTier.BASIC));
    }

    @Override
    public int getEnergyStored() {
        return (Integer)this.container.method_57825((class_9331)FactoryRegistries.ENERGY_COMPONENT.get(), (Object)0);
    }

    @Override
    public void setEnergyStored(int energy) {
        this.container.method_57379((class_9331)FactoryRegistries.ENERGY_COMPONENT.get(), (Object)energy);
    }

    @Override
    public void setStoredTier(FactoryCapacityTier tier) {
        this.container.method_57379((class_9331)FactoryRegistries.STORED_ENERGY_TIER_COMPONENT.get(), (Object)tier);
    }

    @Override
    public void setSupportedTier(FactoryCapacityTier tier) {
        this.container.method_57379((class_9331)FactoryRegistries.ENERGY_TIER_COMPONENT.get(), (Object)tier);
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public class_2487 serializeTag() {
        return new class_2487();
    }

    @Override
    public void deserializeTag(class_2487 nbt) {
    }

    @Override
    public int getMaxConsume() {
        return Math.min(this.getEnergyStored(), this.maxOutput);
    }

    @Override
    public int getMaxReceive() {
        return Math.min(this.getEnergySpace(), this.maxInput);
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }
}

