/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.serialization.Codec;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7677;
import net.minecraft.class_7764;
import org.apache.commons.io.FilenameUtils;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.client.FactoryOptions;

public record MipmapMetadataSection(Map<Integer, Level> levels) {
    public static final MipmapMetadataSection EMPTY = new MipmapMetadataSection(Collections.emptyMap());
    public static final Codec<MipmapMetadataSection> CODEC = Codec.unboundedMap((Codec)Codec.STRING.xmap(Integer::parseInt, Object::toString), Level.CODEC).xmap(MipmapMetadataSection::new, MipmapMetadataSection::levels);
    public static final class_7677<MipmapMetadataSection> TYPE = class_7677.method_45252((String)"mipmap", CODEC);
    public static final Pattern MANUAL_MIPMAP_PATTERN = Pattern.compile(".+/(\\d).png");

    public static MipmapMetadataSection createFallback(class_7764 contents, int maxLevel) {
        String baseName = FilenameUtils.getBaseName((String)contents.method_45816().method_12832());
        if (!baseName.isEmpty()) {
            MipmapMetadataSection section = new MipmapMetadataSection(new HashMap<Integer, Level>());
            for (int i = 1; i <= maxLevel; ++i) {
                class_2960 resourceLocation = contents.method_45816().method_45136("%s/%s/%s.png".formatted(FactoryOptions.MANUAL_MIPMAP_PATH.get(), baseName, i));
                class_310.method_1551().method_1478().method_14486(resourceLocation).ifPresent(resource -> {
                    Matcher matcher = MANUAL_MIPMAP_PATTERN.matcher(resourceLocation.method_12832());
                    while (matcher.find()) {
                        if (matcher.group(1) == null) continue;
                        try {
                            Integer level = Integer.parseInt(matcher.group(1));
                            section.levels().put(level, new Level(resourceLocation));
                        }
                        catch (NumberFormatException e) {
                            FactoryAPI.LOGGER.error("Failed to load fallback mipmap level from texture {}: {}", (Object)contents.method_45816(), (Object)e.getMessage());
                        }
                    }
                });
            }
            return section;
        }
        return EMPTY;
    }

    public record Level(class_2960 texture, class_1011 image) {
        public static final Codec<Level> CODEC = class_2960.field_25139.xmap(Level::new, Level::texture);

        public Level(class_2960 texture) {
            this(texture, Level.readSecure(texture));
        }

        public static class_1011 readSecure(class_2960 texture) {
            try {
                return class_1011.method_4309((InputStream)class_310.method_1551().method_1478().open(texture));
            }
            catch (IOException e) {
                FactoryAPI.LOGGER.error("Failed to load mipmap level from texture {}: {}", (Object)texture, (Object)e.getMessage());
                return null;
            }
        }
    }
}

