/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_9129;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.network.CommonConfigSyncPayload;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.ModInfo;

public record HelloPayload(Collection<String> modIds, CommonNetwork.Identifier<HelloPayload> identifier) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<HelloPayload> ID_S2C = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("hello_s2c"), HelloPayload::createS2C);
    public static final CommonNetwork.Identifier<HelloPayload> ID_C2S = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("hello_c2s"), HelloPayload::createC2S);

    public HelloPayload(CommonNetwork.PlayBuf playBuf, CommonNetwork.Identifier<HelloPayload> identifier) {
        this(((class_9129)playBuf.get()).method_34066(class_2540::method_19772), identifier);
    }

    public static HelloPayload createS2C(CommonNetwork.PlayBuf playBuf) {
        return new HelloPayload(playBuf, ID_S2C);
    }

    public static HelloPayload createC2S(CommonNetwork.PlayBuf playBuf) {
        return new HelloPayload(playBuf, ID_C2S);
    }

    @Override
    public void apply(CommonNetwork.Payload.Context context) {
        class_1657 class_16572 = context.player();
        if (class_16572 instanceof class_3222) {
            class_3222 sp = (class_3222)class_16572;
            CommonNetwork.ENABLED_PLAYERS.putAll((Object)sp.method_5667(), this.modIds);
        } else if (context.isClient()) {
            context.executor().execute(() -> {
                FactoryAPIClient.handleHelloPayload(this);
                CommonNetwork.sendToServer(new HelloPayload(this.modIds.stream().filter(FactoryAPI::isModLoaded).collect(Collectors.toSet()), ID_C2S));
            });
        }
    }

    public static void sendInitialPayloads(class_3222 serverPlayer) {
        CommonNetwork.sendToPlayer(serverPlayer, new HelloPayload(FactoryAPIPlatform.getVisibleModsStream().map(ModInfo::getId).collect(Collectors.toSet()), ID_S2C), true);
        FactoryConfig.COMMON_STORAGES.values().forEach(handler -> CommonNetwork.sendToPlayer(serverPlayer, CommonConfigSyncPayload.of(CommonConfigSyncPayload.ID_S2C, handler)));
    }

    @Override
    public void encode(CommonNetwork.PlayBuf buf) {
        ((class_9129)buf.get()).method_34062(this.modIds, class_2540::method_10814);
    }
}

