/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariablesMap<K, V>
implements Map<K, V> {
    protected Pattern pattern;
    private final Map<K, V> map;
    protected boolean patternNeedsChange = true;

    protected void setChanged() {
        this.patternNeedsChange = true;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void updatePattern() {
        if (this.patternNeedsChange) {
            this.pattern = Pattern.compile("\\$\\{(" + String.join((CharSequence)"|", this.keySet().toString()) + ")}");
            this.patternNeedsChange = false;
        }
    }

    public VariablesMap() {
        this(new HashMap());
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public VariablesMap(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.setChanged();
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V removed = this.map.remove(key);
        if (removed != null) {
            this.setChanged();
        }
        return removed;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.setChanged();
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.setChanged();
        this.map.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry<K, V> entry = iterator.next();
            sb.append((Object)(entry.getKey() == this ? "(this Map)" : entry.getKey()));
            sb.append('=');
            if (entry.getValue() == this) {
                object = "(this Map)";
            } else {
                V v = entry.getValue();
                if (v instanceof Supplier) {
                    Supplier s = (Supplier)v;
                    object = "()->" + String.valueOf(s.get());
                } else {
                    object = entry.getValue();
                }
            }
            sb.append(object);
            if (!iterator.hasNext()) continue;
            sb.append(',').append(' ');
        }
        sb.append('}');
        return sb.toString();
    }
}

