/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.IModifiableTransportHandler;
import wily.factoryapi.base.TransportState;

public class SideList<T extends IModifiableTransportHandler>
extends NonNullList<T> {
    public SideList(Supplier<T> defaultValue) {
        super(new ArrayList<IModifiableTransportHandler>(Arrays.stream(Direction.values()).map(d -> (IModifiableTransportHandler)defaultValue.get()).toList()), (Object)((IModifiableTransportHandler)defaultValue.get()));
    }

    public T get(Direction direction) {
        return (T)(direction == null ? null : (IModifiableTransportHandler)super.get(direction.ordinal()));
    }

    public void put(Direction direction, T side) {
        this.set(direction.ordinal(), side);
    }

    public TransportState getTransport(Direction direction) {
        return this.getTransportOrDefault(direction, TransportState.NONE);
    }

    public TransportState getTransportOrDefault(@Nullable Direction direction, TransportState defaultState) {
        return direction == null ? defaultState : this.get(direction).getTransport();
    }

    public void setTransport(TransportState transportState, Direction direction) {
        this.get(direction).setTransport(transportState);
    }

    public boolean contains(Direction d) {
        return this.get(d) != null;
    }

    public void forEach(BiConsumer<Direction, ? super T> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.size(); ++i) {
            action.accept(Direction.values()[i], (Direction)this.get(i));
        }
    }
}

