/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.base.CraftyTransaction;
import wily.factoryapi.base.FactoryCapacityTier;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.TransportState;

public class SimpleItemCraftyStorage
implements ICraftyEnergyStorage {
    private static final String KEY = "energy";
    private int capacity;
    private final int maxOutput;
    private final int maxInput;
    ItemStack container;
    TransportState transportState;
    final boolean isBlockItem;
    public final FactoryCapacityTier supportableTier;
    public FactoryCapacityTier storedTier = FactoryCapacityTier.BASIC;

    public SimpleItemCraftyStorage(ItemStack stack, int initialEnergy, int capacity, int maxOutput, int maxInput, TransportState transportState, FactoryCapacityTier supportableTier, boolean isBlockItem) {
        this.supportableTier = supportableTier;
        this.isBlockItem = isBlockItem;
        this.capacity = capacity;
        this.container = stack;
        CompoundTag tag = stack.getOrCreateTag();
        if (isBlockItem) {
            tag = tag.getCompound("BlockEntityTag");
        }
        if (tag.getCompound("CYEnergy").isEmpty()) {
            CompoundTag storage = new CompoundTag();
            storage.putInt(KEY, initialEnergy);
            storage.putInt("supportedTier", supportableTier.ordinal());
            storage.putInt("tier", this.storedTier.ordinal());
            tag.put("CYEnergy", (Tag)storage);
            if (isBlockItem) {
                stack.getOrCreateTag().put("BlockEntityTag", (Tag)tag);
            }
        }
        this.transportState = transportState;
        this.maxOutput = maxOutput;
        this.maxInput = maxInput;
    }

    public SimpleItemCraftyStorage(ItemStack stack, int capacity, TransportState transportState, FactoryCapacityTier supportableTier) {
        this(stack, 0, capacity, capacity, capacity, transportState, supportableTier, stack.getItem() instanceof BlockItem);
    }

    private CompoundTag getEnergyCompound() {
        CompoundTag tag = this.container.getOrCreateTag();
        if (this.isBlockItem) {
            tag = tag.getCompound("BlockEntityTag");
        }
        return tag.getCompound("CYEnergy");
    }

    @Override
    public CraftyTransaction receiveEnergy(CraftyTransaction transaction, boolean simulate) {
        if (transaction.isEmpty()) {
            return CraftyTransaction.EMPTY;
        }
        int energyReceived = Math.min(this.getMaxReceive(), transaction.energy);
        int energy = this.getEnergyStored();
        if (!simulate) {
            if (!this.supportableTier.supportTier(transaction.tier)) {
                return CraftyTransaction.EMPTY;
            }
            this.setStoredTier(transaction.tier);
            this.setEnergyStored(energy += energyReceived);
        }
        return new CraftyTransaction(energyReceived, transaction.tier);
    }

    @Override
    public CraftyTransaction consumeEnergy(CraftyTransaction transaction, boolean simulate) {
        if (transaction.isEmpty()) {
            return CraftyTransaction.EMPTY;
        }
        int energy = this.getEnergyStored();
        int energyExtracted = Math.min(energy, Math.min(this.getMaxConsume(), transaction.energy));
        if (!simulate) {
            if (!this.storedTier.supportTier(transaction.tier)) {
                energyExtracted = this.storedTier.convertEnergyTo(energyExtracted, transaction.tier);
            }
            this.setEnergyStored(energy -= energyExtracted);
        }
        return new CraftyTransaction(energyExtracted, transaction.tier);
    }

    @Override
    public FactoryCapacityTier getSupportedTier() {
        return FactoryCapacityTier.values()[this.getEnergyCompound().getInt("tier")];
    }

    @Override
    public FactoryCapacityTier getStoredTier() {
        return FactoryCapacityTier.values()[this.getEnergyCompound().getInt("tier")];
    }

    @Override
    public int getEnergyStored() {
        return this.getEnergyCompound().getInt(KEY);
    }

    @Override
    public void setEnergyStored(int energy) {
        CompoundTag tag = this.getEnergyCompound();
        tag.putInt(KEY, energy);
    }

    @Override
    public void setStoredTier(FactoryCapacityTier tier) {
        CompoundTag tag = this.getEnergyCompound();
        tag.putInt("tier", tier.ordinal());
    }

    @Override
    public void setSupportedTier(FactoryCapacityTier tier) {
        CompoundTag tag = this.getEnergyCompound();
        tag.putInt("supportedTier", tier.ordinal());
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public CompoundTag serializeTag() {
        return this.getEnergyCompound();
    }

    @Override
    public void deserializeTag(CompoundTag nbt) {
        this.container.setTag(nbt);
    }

    @Override
    public int getMaxConsume() {
        return Math.min(this.getEnergyStored(), this.maxOutput);
    }

    @Override
    public int getMaxReceive() {
        return Math.min(this.getEnergySpace(), this.maxInput);
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }
}

