/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.FactoryItemUtil;

public class StackIngredient
extends Ingredient
implements FactoryIngredient {
    public static final MapCodec<StackIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)Registries.ITEM, (Codec)BuiltInRegistries.ITEM.holderByNameCodec(), (boolean)false).fieldOf("items").forGetter(StackIngredient::values), (App)CompoundTag.CODEC.fieldOf("nbt").forGetter(StackIngredient::getTag), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(StackIngredient::isStrict), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(StackIngredient::getCount)).apply((Applicative)builder, StackIngredient::new));
    public static final CommonNetwork.Identifier<StackIngredient> ID = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("stack_ingredient"), StackIngredient::decode);
    private final HolderSet<Item> values;
    private final CompoundTag tag;
    private final boolean strict;
    protected final ItemStack[] stacks;
    private final int count;

    public StackIngredient(HolderSet<Item> values, CompoundTag tag, boolean strict, int count) {
        super(Stream.empty());
        this.values = values;
        this.tag = tag;
        this.strict = strict;
        this.stacks = (ItemStack[])values.stream().map(i -> {
            ItemStack stack = new ItemStack(i, count);
            stack.setTag(tag);
            return stack;
        }).filter(i -> !i.isEmpty()).toArray(ItemStack[]::new);
        this.count = count;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (this.strict) {
            for (ItemStack stack2 : this.stacks) {
                if (!FactoryItemUtil.equalItems(stack, stack2)) continue;
                return true;
            }
            return false;
        }
        return this.values.contains(stack.getItemHolder()) && NbtUtils.compareNbt((Tag)this.tag, (Tag)stack.getTag(), (boolean)true);
    }

    public boolean isEmpty() {
        return this.stacks.length == 0;
    }

    public ItemStack[] getItems() {
        return this.stacks;
    }

    public HolderSet<Item> values() {
        return this.values;
    }

    @Override
    public ItemStack[] getStacks() {
        return this.stacks;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static StackIngredient of(boolean strict, ItemStack stack) {
        return StackIngredient.of(strict, stack, stack.getCount());
    }

    public static StackIngredient of(boolean strict, ItemStack stack, int count) {
        return new StackIngredient((HolderSet<Item>)HolderSet.direct((Holder[])new Holder[]{stack.getItemHolder()}), stack.getTag(), strict, count);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }

    @Override
    public void encode(CommonNetwork.PlayBuf buf) {
        ((FriendlyByteBuf)buf.get()).writeCollection(this.values.stream().toList(), (b, i) -> b.writeId((IdMap)BuiltInRegistries.ITEM, (Object)((Item)i.value())));
        ((FriendlyByteBuf)buf.get()).writeNbt((Tag)this.tag);
        ((FriendlyByteBuf)buf.get()).writeBoolean(this.isStrict());
        ((FriendlyByteBuf)buf.get()).writeByte(this.getCount());
    }

    public static StackIngredient decode(CommonNetwork.PlayBuf buf) {
        return new StackIngredient((HolderSet<Item>)HolderSet.direct((List)((List)((FriendlyByteBuf)buf.get()).readCollection(ArrayList::new, b -> (Holder)b.readById(BuiltInRegistries.ITEM.asHolderIdMap())))), ((FriendlyByteBuf)buf.get()).readNbt(), ((FriendlyByteBuf)buf.get()).readBoolean(), ((FriendlyByteBuf)buf.get()).readByte());
    }
}

