/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public interface FactoryGuiGraphics {
    public GuiGraphics context();

    public MultiBufferSource.BufferSource getBufferSource();

    public void pushBufferSource(MultiBufferSource.BufferSource var1);

    public void popBufferSource();

    public static FactoryGuiGraphics of(GuiGraphics guiGraphics) {
        return ((Accessor)guiGraphics).getFactoryGuiGraphics();
    }

    public static GuiSpriteManager getSprites() {
        return Minecraft.getInstance().getGuiSprites();
    }

    public void blit(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public void blit(ResourceLocation var1, int var2, int var3, int var4, float var5, float var6, int var7, int var8, int var9, int var10);

    public void blit(ResourceLocation var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9, int var10, int var11);

    public void blit(ResourceLocation var1, int var2, int var3, float var4, float var5, int var6, int var7, int var8, int var9);

    public void blitSprite(ResourceLocation var1, int var2, int var3, int var4, int var5);

    public void blitSprite(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6);

    public void blitSprite(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void blit(int var1, int var2, int var3, int var4, int var5, TextureAtlasSprite var6);

    default public void blitSprite(ResourceLocation resourceLocation, int textureWidth, int textureHeight, int uvX, int uvY, int x, int y, int width, int height) {
        this.blitSprite(resourceLocation, textureWidth, textureHeight, uvX, uvY, x, y, 0, width, height);
    }

    public void enableScissor(int var1, int var2, int var3, int var4, boolean var5);

    default public void enableScissor(int x, int y, int xd, int yd) {
        this.enableScissor(x, y, xd, yd, true);
    }

    default public void blitTiledSprite(TextureAtlasSprite textureAtlasSprite, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s) {
        if (l <= 0 || m <= 0) {
            return;
        }
        if (p <= 0 || q <= 0) {
            throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + p + "x" + q);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureAtlasSprite.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = this.context().pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int t = 0; t < l; t += p) {
            int u = Math.min(p, l - t);
            for (int v = 0; v < m; v += q) {
                int w = Math.min(q, m - v);
                this.addBlitSpriteQuad(textureAtlasSprite, bufferBuilder, matrix4f, r, s, n, o, i + t, j + v, k, u, w);
            }
        }
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
    }

    private void addBlitSpriteQuad(TextureAtlasSprite textureAtlasSprite, BufferBuilder bufferBuilder, Matrix4f matrix4f, int i, int j, int k, int l, int m, int n, int o, int p, int q) {
        this.addBlitQuad(bufferBuilder, matrix4f, m, m + p, n, n + q, o, textureAtlasSprite.getU((float)k / (float)i), textureAtlasSprite.getU((float)(k + p) / (float)i), textureAtlasSprite.getV((float)l / (float)j), textureAtlasSprite.getV((float)(l + q) / (float)j));
    }

    private void addBlitQuad(BufferBuilder bufferBuilder, Matrix4f matrix4f, int i, int j, int k, int l, int m, float f, float g, float h, float n) {
        bufferBuilder.vertex(matrix4f, (float)i, (float)k, (float)m).uv(f, h).endVertex();
        bufferBuilder.vertex(matrix4f, (float)i, (float)l, (float)m).uv(f, n).endVertex();
        bufferBuilder.vertex(matrix4f, (float)j, (float)l, (float)m).uv(g, n).endVertex();
        bufferBuilder.vertex(matrix4f, (float)j, (float)k, (float)m).uv(g, h).endVertex();
    }

    public void setColor(int var1, boolean var2);

    public void setColor(float var1, float var2, float var3, float var4, boolean var5);

    default public void setColor(int color) {
        this.setColor(color, false);
    }

    default public void setColor(float r, float g, float b, float a) {
        this.setColor(r, g, b, a, false);
    }

    public float[] getColor();

    default public void clearColor(boolean changeBlend) {
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f, changeBlend);
    }

    default public void clearColor() {
        this.clearColor(false);
    }

    @Deprecated
    public void disableDepthTest();

    @Deprecated
    public void enableDepthTest();

    public static interface Accessor {
        public FactoryGuiGraphics getFactoryGuiGraphics();
    }

    public static interface AtlasAccessor {
        public static AtlasAccessor of(TextureAtlas atlas) {
            return (AtlasAccessor)atlas;
        }

        public Map<ResourceLocation, TextureAtlasSprite> getTexturesByName();
    }
}

