/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import wily.factoryapi.FactoryAPI;

public class FactoryItemUtil {
    public static CompoundTag getFromJson(JsonObject obj) {
        return CompoundTag.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).result().orElseGet(CompoundTag::new);
    }

    public static List<Item> getItemComponents(ItemStack itemStack) {
        ArrayList<Item> list = new ArrayList<Item>();
        if (itemStack.hasTag() && !itemStack.getTag().getList("Components", 8).isEmpty()) {
            itemStack.getTag().getList("Components", 8).forEach(t -> list.add((Item)BuiltInRegistries.ITEM.get(new ResourceLocation(t.getAsString()))));
        }
        return list;
    }

    public static boolean equalItems(ItemStack itemStack, ItemStack itemStack1) {
        return ItemStack.isSameItemSameTags((ItemStack)itemStack, (ItemStack)itemStack1);
    }

    public static boolean compareItems(ItemStack itemStack, ItemStack itemStack1, boolean checkCount) {
        return FactoryItemUtil.compareItems(itemStack, itemStack1, checkCount, true);
    }

    public static boolean compareItems(ItemStack itemStack, ItemStack itemStack1, boolean checkCount, boolean strict) {
        if (strict) {
            if (checkCount) {
                return ItemStack.matches((ItemStack)itemStack, (ItemStack)itemStack1);
            }
            return FactoryItemUtil.equalItems(itemStack, itemStack1);
        }
        if (ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)itemStack1) && (!checkCount || itemStack.getCount() == itemStack1.getCount())) {
            return NbtUtils.compareNbt((Tag)itemStack.getTag(), (Tag)itemStack1.getTag(), (boolean)true);
        }
        return false;
    }

    public static boolean hasCustomName(ItemStack stack) {
        return stack.hasCustomHoverName();
    }

    public static void setCustomName(ItemStack stack, Component name) {
        if (name == null) {
            stack.resetHoverName();
        } else {
            stack.setHoverName(name);
        }
    }

    public static int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return FactoryItemUtil.getEnchantmentLevel(stack, enchantment, (RegistryAccess)FactoryAPI.currentServer.registryAccess());
    }

    public static int getEnchantmentLevel(ItemStack stack, Enchantment enchantment, RegistryAccess registryAccess) {
        return EnchantmentHelper.getItemEnchantmentLevel((Enchantment)enchantment, (ItemStack)stack);
    }
}

