/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.util.FluidInstance;

public interface ItemContainerPlatform {
    public static boolean isBlockItem(ItemStack s) {
        return s.getItem() instanceof BlockItem;
    }

    public static Fluid getBucketFluid(BucketItem item) {
        return item.getFluid();
    }

    public static boolean isFluidContainer(ItemStack stack) {
        return !stack.isEmpty() && ItemContainerPlatform.getItemFluidHandler(stack) != null;
    }

    public static boolean isEnergyContainer(ItemStack stack) {
        return !stack.isEmpty() && ItemContainerPlatform.getItemEnergyStorage(stack) != null;
    }

    public static FluidInstance getFluid(ItemStack stack) {
        return ItemContainerPlatform.isFluidContainer(stack) ? FactoryAPIPlatform.fluidStackToInstance(ItemContainerPlatform.getItemFluidHandler(stack).getFluidInTank(0)) : FluidInstance.empty();
    }

    public static FluidInstance getFluid(Player player, InteractionHand hand) {
        return ItemContainerPlatform.getFluid(player.getItemInHand(hand));
    }

    public static int fillItem(FluidInstance fluidInstance, Player player, InteractionHand hand) {
        return ItemContainerPlatform.fillItem(player.getItemInHand(hand), player, hand, fluidInstance).fluidInstance().getAmount();
    }

    public static ItemFluidContext fillItem(ItemStack stack, FluidInstance fluidInstance) {
        return ItemContainerPlatform.fillItem(stack, null, null, fluidInstance);
    }

    public static FluidInstance drainItem(int maxDrain, Player player, InteractionHand hand) {
        return ItemContainerPlatform.drainItem(maxDrain, player.getItemInHand(hand), player, hand).fluidInstance();
    }

    public static ItemFluidContext drainItem(int maxDrain, ItemStack stack) {
        return ItemContainerPlatform.drainItem(maxDrain, stack, null, null);
    }

    public static int insertEnergy(int energy, Player player, InteractionHand hand) {
        return ItemContainerPlatform.insertEnergy(energy, player.getItemInHand(hand)).contextEnergy();
    }

    public static ItemEnergyContext insertEnergy(int energy, ItemStack stack) {
        return new ItemEnergyContext(ItemContainerPlatform.getItemEnergyStorage(stack).receiveEnergy(energy, false), stack);
    }

    public static int extractEnergy(int energy, Player player, InteractionHand hand) {
        return ItemContainerPlatform.extractEnergy(energy, player.getItemInHand(hand)).contextEnergy();
    }

    public static ItemEnergyContext extractEnergy(int energy, ItemStack stack) {
        return new ItemEnergyContext(ItemContainerPlatform.getItemEnergyStorage(stack).extractEnergy(energy, false), stack);
    }

    public static int getEnergy(ItemStack stack) {
        return ItemContainerPlatform.isEnergyContainer(stack) ? 0 : ItemContainerPlatform.getItemEnergyStorage(stack).getEnergyStored();
    }

    public static IFluidHandlerItem getItemFluidHandler(ItemStack stack) {
        return (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
    }

    public static IEnergyStorage getItemEnergyStorage(ItemStack stack) {
        return (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
    }

    public static ItemFluidContext fillItem(ItemStack stack, Player player, InteractionHand hand, FluidInstance fluidInstance) {
        if (!ItemContainerPlatform.isFluidContainer(stack) || player == null && stack.getCount() != 1) {
            return new ItemFluidContext(stack);
        }
        IFluidHandler.FluidAction action = FactoryAPIPlatform.fluidActionOf(player != null && player.isCreative());
        ItemStack toFill = action.execute() ? stack.copyWithCount(1) : stack.copy();
        IFluidHandlerItem tank = ItemContainerPlatform.getItemFluidHandler(toFill);
        int amount = tank.fill(fluidInstance.toStack(), action);
        if (player != null && amount > 0) {
            SoundEvent sound;
            if (action.execute()) {
                if (stack.getCount() > 1) {
                    player.setItemInHand(hand, stack.copyWithCount(stack.getCount() - 1));
                    player.addItem(tank.getContainer());
                } else {
                    player.setItemInHand(hand, tank.getContainer());
                }
            }
            if ((sound = fluidInstance.getFluid().getFluidType().getSound(fluidInstance.toStack(), SoundActions.BUCKET_FILL)) != null) {
                player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), sound, SoundSource.PLAYERS, 0.6f, 0.8f);
            }
        }
        return new ItemFluidContext(FluidInstance.create(fluidInstance.getFluid(), amount), tank.getContainer());
    }

    public static ItemFluidContext drainItem(int maxDrain, ItemStack stack, Player player, InteractionHand hand) {
        if (!ItemContainerPlatform.isFluidContainer(stack) || player == null && stack.getCount() != 1) {
            return new ItemFluidContext(stack);
        }
        IFluidHandler.FluidAction action = FactoryAPIPlatform.fluidActionOf(player != null && player.isCreative());
        ItemStack toDrain = action.execute() ? stack.copyWithCount(1) : stack.copy();
        IFluidHandlerItem tank = ItemContainerPlatform.getItemFluidHandler(toDrain);
        FluidStack fluidStack = tank.drain(maxDrain, action);
        if (player != null && fluidStack.getAmount() > 0) {
            SoundEvent sound;
            if (action.execute()) {
                if (stack.getCount() > 1) {
                    player.setItemInHand(hand, stack.copyWithCount(stack.getCount() - 1));
                    player.addItem(tank.getContainer());
                } else {
                    player.setItemInHand(hand, tank.getContainer());
                }
            }
            if ((sound = fluidStack.getFluid().getFluidType().getSound(fluidStack, SoundActions.BUCKET_EMPTY)) != null) {
                player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), sound, SoundSource.PLAYERS, 0.6f, 0.8f);
            }
        }
        return new ItemFluidContext(FluidInstance.create(fluidStack.getFluid(), fluidStack.getAmount()), tank.getContainer());
    }

    public record ItemFluidContext(FluidInstance fluidInstance, ItemStack container) {
        public ItemFluidContext(ItemStack container) {
            this(FluidInstance.empty(), container);
        }
    }

    public record ItemEnergyContext(int contextEnergy, ItemStack container) {
        public ItemEnergyContext(ItemStack container) {
            this(0, container);
        }
    }
}

