/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.fabric;

import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandlerApi;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.FluidInstance;

public interface FabricFluidStoragePlatform
extends IPlatformFluidHandler,
IPlatformHandlerApi<Storage<FluidVariant>> {
    @Override
    @NotNull
    default public FluidInstance getFluidInstance() {
        Iterator iterator = ((Storage)this.getHandler()).iterator();
        if (iterator.hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return FluidInstance.create(((FluidVariant)view.getResource()).getFluid(), view.getAmount());
        }
        return FluidInstance.empty();
    }

    @Override
    default public int getMaxFluid() {
        int maxFluid = 0;
        for (StorageView view : (Storage)this.getHandler()) {
            maxFluid += FluidInstance.getMilliBucketsFluidAmount(view.getCapacity());
        }
        return maxFluid;
    }

    @Override
    default public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return ((Storage)this.getHandler()).insert((Object)resource, maxAmount, transaction);
    }

    @Override
    default public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return ((Storage)this.getHandler()).extract((Object)resource, maxAmount, transaction);
    }

    @Override
    default public boolean isFluidValid(@NotNull FluidInstance instance) {
        return true;
    }

    @Override
    default public int fill(FluidInstance resource, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long i;
            try (Transaction nested = transaction.openNested();){
                i = this.insert(FluidVariant.of((class_3611)resource.getFluid()), FluidInstance.getPlatformFluidAmount(resource.getAmount()), (TransactionContext)nested);
                if (!simulate) {
                    nested.commit();
                }
            }
            transaction.commit();
            int n = FluidInstance.getMilliBucketsFluidAmount(i);
            return n;
        }
    }

    @Override
    @NotNull
    default public FluidInstance drain(FluidInstance resource, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long i;
            try (Transaction nested = transaction.openNested();){
                i = this.extract(FluidVariant.of((class_3611)resource.getFluid()), resource.getPlatformAmount(), (TransactionContext)nested);
                if (!simulate) {
                    nested.commit();
                }
            }
            transaction.commit();
            FluidInstance fluidInstance = FluidInstance.create(resource.getFluid(), i);
            return fluidInstance;
        }
    }

    @Override
    @NotNull
    default public FluidInstance drain(int maxDrain, boolean simulate) {
        Iterator iterator = ((Storage)this.getHandler()).iterator();
        if (iterator.hasNext()) {
            StorageView view = (StorageView)iterator.next();
            return this.drain(FluidInstance.create(((FluidVariant)view.getResource()).getFluid(), maxDrain), simulate);
        }
        return FluidInstance.empty();
    }

    @Override
    default public void setFluid(FluidInstance fluidInstance) {
        this.drain(this.getFluidInstance(), false);
        this.fill(fluidInstance, false);
    }

    @Override
    default public SlotsIdentifier identifier() {
        return SlotsIdentifier.GENERIC;
    }

    @Override
    default public TransportState getTransport() {
        return TransportState.EXTRACT_INSERT;
    }
}

