/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.network.SecureExecutor;

public interface CommonNetwork {
    public static final Multimap<UUID, String> ENABLED_PLAYERS = HashMultimap.create();

    public static <T extends Payload> void sendToPlayer(class_3222 serverPlayer, T packetHandler) {
        CommonNetwork.sendToPlayer(serverPlayer, packetHandler, false);
    }

    public static <T extends Payload> void sendToPlayer(class_3222 serverPlayer, T payload, boolean bypassCheck) {
        if (!bypassCheck && !ENABLED_PLAYERS.get((Object)serverPlayer.method_5667()).contains(payload.identifier().location().method_12836())) {
            return;
        }
        ServerPlayNetworking.send((class_3222)serverPlayer, payload);
    }

    public static <T extends Payload> void sendToPlayers(Collection<class_3222> serverPlayers, T payload, boolean bypassCheck) {
        serverPlayers.forEach(s -> CommonNetwork.sendToPlayer(s, payload, bypassCheck));
    }

    public static <T extends Payload> void sendToPlayers(Collection<class_3222> serverPlayers, T payload) {
        CommonNetwork.sendToPlayers(serverPlayers, payload, false);
    }

    public static <T extends Payload> void sendToServer(T payload) {
        CommonNetwork.sendToServer(payload, false);
    }

    public static <T extends Payload> void sendToServer(T payload, boolean bypassCheck) {
        if (!FactoryAPI.isClient() || !bypassCheck && !FactoryAPIClient.hasModOnServer(payload.identifier().location().method_12836())) {
            return;
        }
        ClientPlayNetworking.send(payload);
    }

    public static void encodeComponent(PlayBuf buf, class_2561 component) {
        class_8824.field_48540.encode((Object)((class_9129)buf.get()), (Object)component);
    }

    public static class_2561 decodeComponent(PlayBuf buf) {
        return (class_2561)class_8824.field_48540.decode((Object)((class_9129)buf.get()));
    }

    public static void encodeItemStack(PlayBuf buf, class_1799 stack) {
        class_1799.field_49268.encode((Object)((class_9129)buf.get()), (Object)stack);
    }

    public static class_1799 decodeItemStack(PlayBuf buf) {
        return (class_1799)class_1799.field_49268.decode((Object)((class_9129)buf.get()));
    }

    public static void encodeBuf(PlayBuf buf, PlayBuf toEncode) {
        ((class_9129)buf.get()).method_10804(((class_9129)toEncode.get()).readableBytes());
        ((class_9129)buf.get()).method_52975((ByteBuf)toEncode.get());
    }

    public static PlayBuf decodeBuf(PlayBuf buf) {
        int readable = ((class_9129)buf.get()).method_10816();
        if (readable > 0) {
            return PlayBuf.fromBuf(new class_2540(((class_9129)buf.get()).readBytes(readable)));
        }
        return PlayBuf.create();
    }

    public static interface Payload
    extends class_8710 {
        public void apply(Context var1);

        default public void applyClient() {
            this.apply(Context.createClientContext());
        }

        default public void applyServer(Supplier<class_1657> player) {
            this.apply(Context.createServerContext(player));
        }

        default public void applySided(boolean client, Supplier<class_1657> player) {
            if (client) {
                this.applyClient();
            } else {
                this.applyServer(player);
            }
        }

        public Identifier<? extends Payload> identifier();

        default public void encode(class_9129 buf) {
            this.encode(() -> buf);
        }

        public void encode(PlayBuf var1);

        default public class_8710.class_9154<? extends class_8710> method_56479() {
            return this.identifier().type();
        }

        public static interface Context {
            public SecureExecutor executor();

            public class_1657 player();

            default public MinecraftServer server() {
                return FactoryAPIPlatform.getEntityServer((class_1297)this.player());
            }

            public boolean isClient();

            public static Context createClientContext() {
                return Context.createContext(FactoryAPIClient.SECURE_EXECUTOR, FactoryAPIClient::getClientPlayer, true);
            }

            public static Context createServerContext(Supplier<class_1657> player) {
                return Context.createContext(FactoryAPI.SECURE_EXECUTOR, player, true);
            }

            public static Context createContext(final SecureExecutor executor, final Supplier<class_1657> playerSupplier, final boolean isClient) {
                return new Context(){

                    @Override
                    public SecureExecutor executor() {
                        return executor;
                    }

                    @Override
                    public class_1657 player() {
                        return (class_1657)playerSupplier.get();
                    }

                    @Override
                    public boolean isClient() {
                        return isClient;
                    }
                };
            }
        }
    }

    public static interface Identifier<T extends Payload> {
        public class_2960 location();

        public T decode(class_9129 var1);

        public class_8710.class_9154<T> type();

        public class_9139<class_9129, T> codec();

        public static <T extends Payload> Identifier<T> create(class_2960 location, Supplier<T> decoder) {
            return Identifier.create(location, (PlayBuf b) -> (Payload)decoder.get());
        }

        public static <T extends Payload> Identifier<T> create(final class_2960 location, final Function<PlayBuf, T> decoder) {
            final class_8710.class_9154 type = new class_8710.class_9154(location);
            final class_9139 codec = class_9139.method_56437((b, p) -> p.encode((class_9129)b), b -> (Payload)decoder.apply(() -> b));
            return new Identifier<T>(){

                @Override
                public class_2960 location() {
                    return location;
                }

                @Override
                public T decode(class_9129 buf) {
                    return (Payload)decoder.apply(() -> buf);
                }

                @Override
                public class_8710.class_9154<T> type() {
                    return type;
                }

                @Override
                public class_9139<class_9129, T> codec() {
                    return codec;
                }
            };
        }
    }

    public static interface PlayBuf
    extends Supplier<class_9129> {
        public static PlayBuf create() {
            return PlayBuf.fromBuf(new class_2540(Unpooled.buffer()));
        }

        public static PlayBuf of(class_9129 buf) {
            return () -> buf;
        }

        public static PlayBuf fromBuf(class_2540 buf) {
            return PlayBuf.of(new class_9129((ByteBuf)buf, FactoryAPIPlatform.getRegistryAccess()));
        }
    }

    public static abstract class EmptyPayload
    implements Payload {
        private final Identifier<? extends Payload> identifier;

        public EmptyPayload(Identifier<? extends Payload> identifier) {
            this.identifier = identifier;
        }

        @Override
        public void encode(PlayBuf buf) {
        }

        @Override
        public Identifier<? extends Payload> identifier() {
            return this.identifier;
        }
    }
}

