/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9695;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.network.CommonNetwork;

public class CommonRecipeManager {
    private static final Set<class_3956<?>> recipeTypesToSync = new HashSet();
    private static Map<class_3956<?>, Map<class_2960, class_8786<?>>> recipesByType = Collections.emptyMap();

    public static <R extends class_1860<?>> class_8786<R> byId(class_2960 id, class_3956<R> type) {
        return (class_8786)recipesByType.getOrDefault(type, Collections.emptyMap()).get(id);
    }

    public static <R extends class_1860<?>> Collection<class_8786<R>> byType(class_3956<R> type) {
        return recipesByType.get(type).values();
    }

    public static <R extends class_1860<I>, I extends class_9695> Optional<class_8786<R>> getRecipeFor(class_3956<R> type, I input, class_1937 level) {
        Collection<class_8786<R>> recipes = CommonRecipeManager.byType(type);
        for (class_8786<R> recipe : recipes) {
            if (!recipe.comp_1933().method_8115(input, level)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public static <R extends class_1860<I>, I extends class_9695> Optional<class_1799> getResultFor(class_3956<R> type, I input, class_1937 level) {
        return CommonRecipeManager.getRecipeFor(type, input, level).map(r -> r.comp_1933().method_8116(input, (class_7225.class_7874)level.method_30349()));
    }

    public static void updateRecipes(class_1863 manager) {
        recipesByType = manager.method_8126().stream().collect(Collectors.groupingBy(h -> h.comp_1933().method_17716(), Collectors.toMap(h -> h.comp_1932().method_29177(), Function.identity())));
        for (class_3956<?> recipeType : recipeTypesToSync) {
            ClientPayload.getInstance().syncRecipeTypes.put(recipeType, recipesByType.get(recipeType));
        }
    }

    public static void clearRecipes() {
        recipesByType = Collections.emptyMap();
        ClientPayload.getInstance().syncRecipeTypes.clear();
    }

    public static boolean canSyncType(class_3956<?> type) {
        return recipeTypesToSync.contains(type);
    }

    public static void addRecipeTypeToSync(class_3956<?> recipeType) {
        recipeTypesToSync.add(recipeType);
    }

    public record ClientPayload(Map<class_3956<?>, Map<class_2960, class_8786<?>>> syncRecipeTypes) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<ClientPayload> ID = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("send_client_recipes"), ClientPayload::new);
        private static final ClientPayload instance = new ClientPayload(new HashMap());

        public ClientPayload(CommonNetwork.PlayBuf buf) {
            this(((class_9129)buf.get()).method_34067(b -> (class_3956)b.method_52962(arg_0 -> ((class_2378)class_7923.field_41188).method_10200(arg_0)), b -> b.method_34067(class_2540::method_10810, b1 -> (class_8786)class_8786.field_48357.decode((Object)((class_9129)buf.get())))));
        }

        public static ClientPayload getInstance() {
            return instance;
        }

        @Override
        public void apply(CommonNetwork.Payload.Context context) {
            recipesByType = this.syncRecipeTypes;
        }

        @Override
        public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
            return ID;
        }

        @Override
        public void encode(CommonNetwork.PlayBuf buf) {
            ((class_9129)buf.get()).method_34063(this.syncRecipeTypes, (b, t) -> b.method_52963(arg_0 -> ((class_2378)class_7923.field_41188).method_10206(arg_0), t), (b, t) -> b.method_34063(t, class_2540::method_10812, (b1, h) -> class_8786.field_48357.encode((Object)((class_9129)buf.get()), h)));
        }
    }
}

