/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.FactoryItemUtil;

public class StackIngredient
extends Ingredient
implements FactoryIngredient {
    public static final MapCodec<StackIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)Registries.ITEM, (Codec)BuiltInRegistries.ITEM.holderByNameCodec(), (boolean)false).fieldOf("items").forGetter(StackIngredient::values), (App)DataComponentExactPredicate.CODEC.fieldOf("components").forGetter(StackIngredient::components), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(StackIngredient::isStrict), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(StackIngredient::getCount)).apply((Applicative)builder, StackIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, StackIngredient> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries((Codec)CODEC.codec());
    public static final CommonNetwork.Identifier<StackIngredient> ID = CommonNetwork.Identifier.create(FactoryAPI.createModLocation("stack_ingredient"), StackIngredient::decode);
    private final HolderSet<Item> values;
    private final DataComponentExactPredicate components;
    private final boolean strict;
    protected final ItemStack[] stacks;
    private final int count;

    public StackIngredient(HolderSet<Item> values, DataComponentExactPredicate components, boolean strict, int count) {
        super(values);
        this.values = values;
        this.components = components;
        this.strict = strict;
        this.stacks = (ItemStack[])values.stream().map(i -> {
            ItemStack stack = new ItemStack(i, count);
            stack.applyComponents(components.asPatch());
            return stack;
        }).filter(i -> !i.isEmpty()).toArray(ItemStack[]::new);
        this.count = count;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (this.strict) {
            for (ItemStack stack2 : this.stacks) {
                if (!FactoryItemUtil.equalItems(stack, stack2)) continue;
                return true;
            }
            return false;
        }
        return this.values.contains(stack.getItemHolder()) && this.components.test((DataComponentGetter)stack);
    }

    public HolderSet<Item> values() {
        return this.values;
    }

    @Override
    public ItemStack[] getStacks() {
        return this.stacks;
    }

    public DataComponentExactPredicate components() {
        return this.components;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static StackIngredient of(boolean strict, ItemStack stack) {
        return StackIngredient.of(strict, stack, stack.getCount());
    }

    public static StackIngredient of(boolean strict, ItemStack stack, int count) {
        return StackIngredient.of(strict, stack.getComponents(), count, new ItemLike[]{stack.getItem()});
    }

    public static <T> StackIngredient of(boolean strict, DataComponentType<? super T> type, T value, int count, ItemLike ... items) {
        return StackIngredient.of(strict, DataComponentExactPredicate.builder().expect(type, value).build(), count, items);
    }

    public static <T> StackIngredient of(boolean strict, Supplier<? extends DataComponentType<? super T>> type, T value, int count, ItemLike ... items) {
        return StackIngredient.of(strict, type.get(), value, count, items);
    }

    public static StackIngredient of(boolean strict, DataComponentMap map, int count, ItemLike ... items) {
        return StackIngredient.of(strict, DataComponentExactPredicate.allOf((DataComponentMap)map), count, items);
    }

    @SafeVarargs
    public static StackIngredient of(boolean strict, DataComponentMap map, int count, Holder<Item> ... items) {
        return StackIngredient.of(strict, DataComponentExactPredicate.allOf((DataComponentMap)map), count, items);
    }

    public static StackIngredient of(boolean strict, DataComponentMap map, HolderSet<Item> items, int count) {
        return StackIngredient.of(strict, DataComponentExactPredicate.allOf((DataComponentMap)map), items, count);
    }

    @SafeVarargs
    public static StackIngredient of(boolean strict, DataComponentExactPredicate predicate, int count, Holder<Item> ... items) {
        return StackIngredient.of(strict, predicate, (HolderSet<Item>)HolderSet.direct(items), count);
    }

    public static StackIngredient of(boolean strict, DataComponentExactPredicate predicate, int count, ItemLike ... items) {
        return StackIngredient.of(strict, predicate, (HolderSet<Item>)HolderSet.direct(Arrays.stream(items).map(ItemLike::asItem).map(Item::builtInRegistryHolder).toList()), count);
    }

    public static StackIngredient of(boolean strict, DataComponentExactPredicate predicate, HolderSet<Item> items, int count) {
        return new StackIngredient(items, predicate, strict, count);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }

    @Override
    public void encode(CommonNetwork.PlayBuf buf) {
        STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf.get()), (Object)this);
    }

    public static StackIngredient decode(CommonNetwork.PlayBuf buf) {
        return (StackIngredient)STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf.get()));
    }
}

