/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.ListMap;

public interface FactoryIngredient
extends Predicate<ItemStack>,
CommonNetwork.Payload {
    public static final ListMap<ResourceLocation, CommonNetwork.Identifier<? extends FactoryIngredient>> map = new ListMap();
    public static final CommonNetwork.Identifier<FactoryIngredient> DEFAULT_ID = CommonNetwork.Identifier.create(FactoryAPI.createVanillaLocation("ingredient"), FactoryIngredient::decodeDefaultIngredient);

    public static void init() {
        FactoryIngredient.register(StackIngredient.ID);
    }

    public ItemStack[] getStacks();

    public static void register(CommonNetwork.Identifier<? extends FactoryIngredient> id) {
        map.put(id.location(), id);
    }

    public static FactoryIngredient of(Ingredient ing) {
        return (FactoryIngredient)ing;
    }

    public static FactoryIngredient of(ItemStack ... stacks) {
        return FactoryIngredient.of(Ingredient.of((ItemLike[])((ItemLike[])Arrays.stream(stacks).map(ItemStack::getItem).toArray(Item[]::new))));
    }

    default public Ingredient toIngredient() {
        return (Ingredient)this;
    }

    @Override
    default public void apply(CommonNetwork.Payload.Context context) {
    }

    public int getCount();

    public static void encode(CommonNetwork.PlayBuf buf, FactoryIngredient ingredient) {
        ((FriendlyByteBuf)buf.get()).writeResourceLocation(ingredient.identifier().location());
        ingredient.encode(buf);
    }

    public static FactoryIngredient decode(CommonNetwork.PlayBuf buf) {
        CommonNetwork.Identifier<FactoryIngredient> id = map.getOrDefault(((FriendlyByteBuf)buf.get()).readResourceLocation(), DEFAULT_ID);
        return id.decode((FriendlyByteBuf)buf.get());
    }

    public static FactoryIngredient decodeDefaultIngredient(CommonNetwork.PlayBuf buf) {
        return FactoryIngredient.of(Ingredient.fromNetwork((FriendlyByteBuf)((FriendlyByteBuf)buf.get())));
    }
}

