/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client.screen;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryConfigWidgets;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.config.FactoryCommonOptions;
import wily.factoryapi.base.config.FactoryConfig;

public class FactoryConfigScreen
extends Screen {
    public static final Component TITLE = Component.translatable((String)"options.factory_api.title");
    protected final List<AbstractWidget> optionWidgets = new ArrayList<AbstractWidget>();
    public static final List<FactoryConfig<?>> CONFIGS = new ArrayList<FactoryConfig<Boolean>>(List.of(FactoryOptions.NEAREST_MIPMAP_SCALING, FactoryOptions.RANDOM_BLOCK_ROTATIONS, FactoryOptions.UI_DEFINITION_LOGGING, FactoryCommonOptions.EXPRESSION_FAIL_LOGGING));
    public final Screen parent;
    private ConfigList list;

    public FactoryConfigScreen(Screen screen, List<FactoryConfig<?>> configs, Component title) {
        super(title);
        this.parent = screen;
        for (FactoryConfig<?> config : configs) {
            AbstractWidget widget;
            if (config.getStorageAccess().allowSync() && !config.getStorageAccess().allowClientSync((Player)Minecraft.getInstance().player) || (widget = FactoryConfigWidgets.createWidget(config, 0, 0, 150, b -> config.sync())) == null) continue;
            this.optionWidgets.add(widget);
        }
    }

    public static FactoryConfigScreen createFactoryAPIConfigScreen(Screen parent) {
        return new FactoryConfigScreen(parent, CONFIGS, TITLE);
    }

    protected void init() {
        this.list = (ConfigList)this.addRenderableWidget((GuiEventListener)new ConfigList(this.minecraft, this.width, this.height - 64, 32, 25, this));
        this.list.addSmall(this.optionWidgets);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 100, this.height - 27, 200, 20).build());
        super.init();
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public static class ConfigList
    extends ContainerObjectSelectionList<Entry> {
        private final Screen screen;

        public ConfigList(Minecraft minecraft, int screenWidth, int listHeight, int k, int l, Screen screen) {
            super(minecraft, screenWidth, listHeight, k, l);
            this.screen = screen;
        }

        public void addSmall(List<AbstractWidget> list) {
            for (int i = 0; i < list.size(); i += 2) {
                this.addSmall(list.get(i), i < list.size() - 1 ? list.get(i + 1) : null);
            }
        }

        public void addSmall(AbstractWidget arg, @Nullable AbstractWidget arg2) {
            this.addEntry((AbstractSelectionList.Entry)Entry.small(arg, arg2, this.screen));
        }

        public int getRowWidth() {
            return 310;
        }

        public static class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
            private final List<AbstractWidget> children;
            private final Screen screen;

            Entry(List<AbstractWidget> list, Screen arg) {
                this.children = ImmutableList.copyOf(list);
                this.screen = arg;
            }

            public static Entry big(List<AbstractWidget> list, Screen arg) {
                return new Entry(list, arg);
            }

            public static Entry small(AbstractWidget arg, @Nullable AbstractWidget arg2, Screen arg3) {
                return arg2 == null ? new Entry((List<AbstractWidget>)ImmutableList.of((Object)arg), arg3) : new Entry((List<AbstractWidget>)ImmutableList.of((Object)arg, (Object)arg2), arg3);
            }

            public void render(GuiGraphics arg, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
                int p = 0;
                int q = this.screen.width / 2 - 155;
                for (AbstractWidget abstractWidget : this.children) {
                    abstractWidget.setPosition(q + p, j);
                    abstractWidget.render(arg, n, o, f);
                    p += 160;
                }
            }

            public List<? extends GuiEventListener> children() {
                return this.children;
            }

            public List<? extends NarratableEntry> narratables() {
                return this.children;
            }
        }
    }
}

