/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.WidgetAccessor;
import wily.factoryapi.util.FactoryScreenUtil;

@Mixin(value={AbstractButton.class})
public abstract class AbstractButtonMixin
extends AbstractWidget
implements WidgetAccessor {
    public AbstractButtonMixin(int i, int j, int k, int l, Component component) {
        super(i, j, k, l, component);
    }

    @Inject(method={"onClick"}, at={@At(value="HEAD")}, cancellable=true)
    public void onClick(double d, double e, CallbackInfo ci) {
        if (this.getOnPressOverride() != null) {
            super.onClick(d, e);
            ci.cancel();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/AbstractButton;onPress()V")}, cancellable=true)
    public void keyPressed(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        if (this.getOnPressOverride() != null) {
            this.getOnPressOverride().accept(this);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"renderString"}, at={@At(value="HEAD")})
    public void renderString(GuiGraphics guiGraphics, Font font, int i, CallbackInfo ci) {
        ResourceLocation sprite = this.getSpriteOverride();
        if (sprite != null) {
            FactoryScreenUtil.enableBlend();
            FactoryGuiGraphics.of(guiGraphics).setColor(1.0f, 1.0f, 1.0f, this.alpha);
            FactoryGuiGraphics.of(guiGraphics).blitSprite(sprite, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            FactoryGuiGraphics.of(guiGraphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            FactoryScreenUtil.disableBlend();
        }
    }
}

