/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base.neoforge;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.ItemCapability;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.base.IFactoryItem;

@Mixin(value={ItemCapability.class})
public class ItemCapabilityMixin {
    @Inject(method={"getCapability"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    public void getCapability(ItemStack stack, Object context, CallbackInfoReturnable<Object> cir) {
        Item item;
        if (cir.getReturnValue() == null && (item = stack.getItem()) instanceof IFactoryItem) {
            IFactoryItem item2 = (IFactoryItem)item;
            FactoryStorage<?> storage = FactoryAPIPlatform.ITEM_CAPABILITY_MAP.get(this);
            ArbitrarySupplier<?> handler = item2.getStorage(storage, stack);
            if (storage != null && handler.isPresent()) {
                cir.setReturnValue(handler.get());
            }
        }
    }
}

