/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.config;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.MinecraftServerAccessor;
import wily.factoryapi.base.config.FactoryConfigControl;
import wily.factoryapi.base.config.FactoryConfigDisplay;
import wily.factoryapi.base.config.FactoryMixinToggle;
import wily.factoryapi.base.network.CommonConfigSyncPayload;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.ListMap;

public interface FactoryConfig<T>
extends Bearer<T> {
    public static final ListMap<ResourceLocation, StorageHandler> COMMON_STORAGES = new ListMap();
    public static final Logger LOGGER = LogManager.getLogger((String)"factory_config");

    public static StorageHandler registerCommonStorage(ResourceLocation location, StorageHandler handler) {
        COMMON_STORAGES.put(location, handler);
        return handler;
    }

    public String getKey();

    public T defaultValue();

    default public void setDefault(T value) {
    }

    default public void reset() {
        this.set(this.defaultValue());
    }

    public FactoryConfigControl<T> control();

    public StorageAccess getStorageAccess();

    public FactoryConfigDisplay<T> getDisplay();

    public static <T> void saveOptionAndConsume(FactoryConfig<T> config, T newValue, Consumer<T> consumer) {
        config.set(newValue);
        config.save();
        consumer.accept(newValue);
    }

    public static FactoryConfig<Boolean> fromMixin(FactoryMixinToggle toggle, FactoryMixinToggle.Storage storage) {
        return FactoryConfig.create(toggle.key, (FactoryConfigDisplay)toggle.configDisplay.get(), toggle.defaultValue, toggle, FactoryConfigControl.TOGGLE, b -> {}, storage::save);
    }

    default public void save() {
        this.getStorageAccess().save();
    }

    default public void sync() {
        this.getStorageAccess().sync(this);
    }

    default public DataResult<T> decode(Dynamic<?> dynamic) {
        return this.getStorageAccess().decode(this, dynamic);
    }

    default public DataResult<T> decodeDefault(Dynamic<?> dynamic) {
        return this.getStorageAccess().decode(this.control(), this::setDefault, dynamic);
    }

    default public <E> DataResult<E> encode(DynamicOps<E> ops) {
        return this.getStorageAccess().encode(this, ops);
    }

    default public <E> DataResult<E> encodeDefault(DynamicOps<E> ops) {
        return this.getStorageAccess().encode(this.control(), this.defaultValue(), ops);
    }

    public static <T> FactoryConfig<T> create(String key, FactoryConfigDisplay<T> display, T defaultValue, Bearer<T> bearer, FactoryConfigControl<T> control, Consumer<T> consumer, StorageAccess access) {
        return new Instance<T>(key, display, defaultValue, bearer, control, consumer, access);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static Builder<Boolean> toggleBuilder() {
        return new Builder<Boolean>().control(FactoryConfigControl.TOGGLE);
    }

    public static FactoryConfig<Boolean> createBoolean(String key, FactoryConfigDisplay<Boolean> display, boolean defaultValue, Consumer<Boolean> consumer, StorageAccess access) {
        return FactoryConfig.create(key, display, defaultValue, Bearer.of(defaultValue), FactoryConfigControl.TOGGLE, consumer, access);
    }

    public static FactoryConfig<Integer> createInteger(String key, FactoryConfigDisplay<Integer> display, int min, int max, int defaultValue, Consumer<Integer> consumer, StorageAccess access) {
        return FactoryConfig.createInteger(key, display, new FactoryConfigControl.Int(min, () -> max, Integer.MAX_VALUE), defaultValue, consumer, access);
    }

    public static FactoryConfig<Integer> createInteger(String key, FactoryConfigDisplay<Integer> display, FactoryConfigControl<Integer> control, int defaultValue, Consumer<Integer> consumer, StorageAccess access) {
        return FactoryConfig.create(key, display, control, defaultValue, consumer, access);
    }

    public static <T> FactoryConfig<T> create(String key, FactoryConfigDisplay<T> display, FactoryConfigControl<T> control, T defaultValue, Consumer<T> consumer, StorageAccess access) {
        return FactoryConfig.create(key, display, defaultValue, Bearer.of(defaultValue), control, consumer, access);
    }

    public static boolean hasCommonConfigEnabled(FactoryConfig<Boolean> config, boolean defaultValue) {
        StorageHandler h;
        StorageAccess storageAccess;
        return FactoryAPI.isClient() && (storageAccess = config.getStorageAccess()) instanceof StorageHandler && !FactoryAPIClient.hasModOnServer(COMMON_STORAGES.getKey(h = (StorageHandler)storageAccess).getNamespace()) ? defaultValue : (Boolean)config.get();
    }

    public static boolean hasCommonConfigEnabled(FactoryConfig<Boolean> config) {
        return FactoryConfig.hasCommonConfigEnabled(config, false);
    }

    public static <T> void decodeConfigs(Map<String, ? extends FactoryConfig<?>> configs, Dynamic<T> dynamic) {
        dynamic.asMapOpt().result().ifPresent((? super T m) -> m.forEach(p -> ((Dynamic)p.getFirst()).asString().result().ifPresent((? super T s) -> {
            FactoryConfig config = (FactoryConfig)configs.get(s);
            if (config == null) {
                LOGGER.warn("Config named as {} with value {} wasn't found", s, (Object)((Dynamic)p.getSecond()).toString());
            } else {
                config.decode((Dynamic)p.getSecond());
            }
        })));
    }

    public static <T> T encodeConfigs(Map<String, ? extends FactoryConfig<?>> configs, DynamicOps<T> ops) {
        return (T)ops.createMap(configs.entrySet().stream().collect(Collectors.toMap(e -> ops.createString((String)e.getKey()), e -> ((FactoryConfig)e.getValue()).encode(ops).result().orElseThrow())));
    }

    public static boolean load(File file, Map<String, ? extends FactoryConfig<?>> configs, boolean isDefault) {
        if (!file.exists()) {
            return false;
        }
        boolean makeBackup = false;
        try (BufferedReader r = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)r);
            if (jsonElement instanceof JsonObject) {
                JsonObject obj = (JsonObject)jsonElement;
                obj.asMap().forEach((s, e) -> {
                    FactoryConfig config = (FactoryConfig)configs.get(s);
                    if (config == null) {
                        LOGGER.warn("Config named as {} from {} config file wasn't found", s, (Object)file.toString());
                    } else if (isDefault) {
                        config.decodeDefault(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                    } else {
                        config.decode(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                    }
                });
            } else {
                LOGGER.warn("Config file {} can't be loaded, it's certainly corrupt or in a wrong syntax", (Object)file.toString());
                makeBackup = true;
            }
        }
        catch (IOException | RuntimeException e2) {
            LOGGER.warn("Failed to load the config {}: {}", (Object)file.toString(), (Object)e2.getMessage());
            makeBackup = true;
        }
        if (makeBackup) {
            File invalidJson = new File(file.getParent(), file.getName() + "_old");
            try {
                file.renameTo(invalidJson);
            }
            catch (SecurityException e3) {
                LOGGER.warn("Failed to make a backup of {} config file to {}: {}", (Object)file.toString(), (Object)invalidJson.toString(), (Object)e3.getMessage());
            }
        }
        return !makeBackup;
    }

    public static boolean save(File file, Map<String, ? extends FactoryConfig<?>> configs, boolean isDefault) {
        boolean bl;
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        JsonWriter w = new JsonWriter((Writer)Files.newWriter((File)file, (Charset)Charsets.UTF_8));
        try {
            w.setSerializeNulls(false);
            w.setIndent("  ");
            JsonObject obj = new JsonObject();
            configs.forEach((s, config) -> (isDefault ? config.encodeDefault((DynamicOps)JsonOps.INSTANCE) : config.encode((DynamicOps)JsonOps.INSTANCE)).resultOrPartial(error -> LOGGER.warn("Failed to save config named as {} from {} config file: {}", s, (Object)file.toString(), error)).ifPresent((? super T e) -> obj.add(s, e)));
            GsonHelper.writeValue((JsonWriter)w, (JsonElement)obj, Comparator.naturalOrder());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    w.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to save the config {}: {}", (Object)file.toString(), (Object)e);
                return false;
            }
        }
        w.close();
        return bl;
    }

    public static interface StorageAccess {
        public void save();

        default public <T, E> DataResult<E> encode(FactoryConfig<T> config, DynamicOps<E> ops) {
            return this.encode(config.control(), config.get(), ops);
        }

        default public <T, E> DataResult<E> encode(FactoryConfigControl<T> control, T value, DynamicOps<E> ops) {
            return control.codec().encodeStart(ops, value);
        }

        default public <T> DataResult<T> decode(FactoryConfig<T> config, Dynamic<?> dynamic) {
            return this.decode(config.control(), v -> this.whenParsed(config, v), dynamic);
        }

        default public <T> DataResult<T> decode(FactoryConfigControl<T> control, Consumer<T> setter, Dynamic<?> dynamic) {
            DataResult result = control.codec().parse(dynamic);
            result.result().ifPresent(setter);
            return result;
        }

        default public <T> void whenParsed(FactoryConfig<T> config, T newValue) {
            config.set(newValue);
        }

        default public <T> void sync(FactoryConfig<T> config) {
        }

        default public boolean allowSync() {
            return false;
        }

        default public boolean allowClientSync(Player player) {
            return this.allowSync() && player != null && (player.hasPermissions(2) || FactoryAPIPlatform.getEntityServer((Entity)player).isSingleplayerOwner(player.nameAndId()));
        }
    }

    public static class Instance<T>
    implements FactoryConfig<T> {
        private final String key;
        private final FactoryConfigDisplay<T> display;
        private T defaultValue;
        private final Bearer<T> bearer;
        private final FactoryConfigControl<T> control;
        private final Consumer<T> consumer;
        private final StorageAccess access;

        public Instance(String key, FactoryConfigDisplay<T> display, T defaultValue, Bearer<T> bearer, FactoryConfigControl<T> control, Consumer<T> consumer, StorageAccess access) {
            this.key = key;
            this.display = display;
            this.defaultValue = defaultValue;
            this.bearer = bearer;
            this.control = control;
            this.consumer = consumer;
            this.access = access;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T defaultValue() {
            return this.defaultValue;
        }

        @Override
        public void setDefault(T value) {
            this.defaultValue = value;
        }

        @Override
        public FactoryConfigControl<T> control() {
            return this.control;
        }

        @Override
        public StorageAccess getStorageAccess() {
            return this.access;
        }

        @Override
        public FactoryConfigDisplay<T> getDisplay() {
            return this.display;
        }

        @Override
        public void set(T t) {
            this.bearer.set(t);
            this.consumer.accept(t);
        }

        @Override
        public T get() {
            return this.bearer.get();
        }
    }

    public static class Builder<T> {
        private String key;
        private T defaultValue;
        private FactoryConfigDisplay<T> display;
        private FactoryConfigControl<T> control;
        private Consumer<T> afterSet = value -> {};

        public Builder<T> key(String key) {
            this.key = key;
            return this;
        }

        public Builder<T> display(FactoryConfigDisplay<T> display) {
            this.display = display;
            return this;
        }

        public Builder<T> displayFromKey(Function<String, FactoryConfigDisplay<T>> display) {
            return this.display(display.apply(this.key));
        }

        public Builder<T> control(FactoryConfigControl<T> control) {
            this.control = control;
            return this;
        }

        public Builder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<T> afterSet(Consumer<T> afterSet) {
            this.afterSet = afterSet;
            return this;
        }

        public FactoryConfig<T> build(StorageAccess access) {
            return FactoryConfig.create(Objects.requireNonNull(this.key, "The key of FactoryConfig can't be null"), this.display, Objects.requireNonNull(this.control, "The control of FactoryConfig can't be null"), Objects.requireNonNull(this.defaultValue, "The default value of FactoryConfig can't be null"), this.afterSet, access);
        }

        public FactoryConfig<T> buildAndRegister(StorageHandler handler) {
            return handler.register(this.build(handler));
        }
    }

    public static class StorageHandler
    implements StorageAccess {
        public File file;
        public File defaultFile;
        public final Map<String, FactoryConfig<?>> configMap;
        protected final boolean allowSync;
        protected boolean serverOnly;
        public final FactoryEvent<Consumer<StorageHandler>> preLoad = new FactoryEvent<Consumer>(e -> m -> e.invokeAll(l -> l.accept(m)));
        public final FactoryEvent<Consumer<StorageHandler>> afterLoad = new FactoryEvent<Consumer>(e -> m -> e.invokeAll(l -> l.accept(m)));
        public final FactoryEvent<Consumer<StorageHandler>> preSave = new FactoryEvent<Consumer>(e -> m -> e.invokeAll(l -> l.accept(m)));
        public final FactoryEvent<Consumer<StorageHandler>> afterSave = new FactoryEvent<Consumer>(e -> m -> e.invokeAll(l -> l.accept(m)));

        public StorageHandler(Map<String, FactoryConfig<?>> configMap, boolean allowSync) {
            this.configMap = configMap;
            this.allowSync = allowSync;
        }

        public StorageHandler(boolean allowSync) {
            this(new HashMap(), allowSync);
        }

        public StorageHandler() {
            this(false);
        }

        public StorageHandler withFile(File file) {
            this.file = file;
            return this;
        }

        public StorageHandler withDefaultFile(File file) {
            this.defaultFile = file;
            return this;
        }

        public static StorageHandler fromMixin(final FactoryMixinToggle.Storage storage, boolean allowSync) {
            return new StorageHandler(storage.configMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> FactoryConfig.fromMixin((FactoryMixinToggle)e.getValue(), storage))), allowSync){

                @Override
                public void save() {
                    storage.save();
                }

                @Override
                public void load() {
                    storage.load();
                }
            };
        }

        public FactoryConfig<Boolean> getMixinToggle(FactoryMixinToggle toggle) {
            return this.configMap.get(toggle.key);
        }

        public StorageHandler withFile(String configDirectoryFile) {
            return this.withFile(FactoryAPI.getConfigDirectory().resolve(configDirectoryFile).toFile());
        }

        public StorageHandler withDefaultFile(String configDirectoryFile) {
            return this.withDefaultFile(FactoryAPI.getConfigDirectory().resolve(configDirectoryFile).toFile());
        }

        public StorageHandler withServerFile(MinecraftServer server, String serverDirectoryFile) {
            this.serverOnly = true;
            return this.withFile(MinecraftServerAccessor.of(server).getStorageSource().getDimensionPath(Level.OVERWORLD).resolve(serverDirectoryFile).toFile());
        }

        public <T> void setAndSync(FactoryConfig<T> config, T value) {
            config.set(value);
            this.sync(config);
        }

        @Override
        public <T> void sync(FactoryConfig<T> config) {
            if (!this.allowSync) {
                return;
            }
            if (FactoryAPI.currentServer == null) {
                CommonNetwork.sendToServer(CommonConfigSyncPayload.of(CommonConfigSyncPayload.ID_C2S, this, config));
            } else {
                CommonNetwork.sendToPlayers(FactoryAPI.currentServer.getPlayerList().getPlayers(), CommonConfigSyncPayload.of(CommonConfigSyncPayload.ID_S2C, this, config));
            }
        }

        public void sync() {
            if (!this.allowSync) {
                return;
            }
            if (FactoryAPI.currentServer == null) {
                CommonNetwork.sendToServer(CommonConfigSyncPayload.of(CommonConfigSyncPayload.ID_C2S, this));
            } else {
                CommonNetwork.sendToPlayers(FactoryAPI.currentServer.getPlayerList().getPlayers(), CommonConfigSyncPayload.of(CommonConfigSyncPayload.ID_S2C, this));
            }
        }

        @Override
        public boolean allowSync() {
            return this.allowSync;
        }

        public void reset() {
            this.configMap.values().forEach(FactoryConfig::reset);
        }

        public void resetAndLoad() {
            this.reset();
            this.load();
        }

        public boolean isServerManaged() {
            return this.allowSync || this.isServerOnly();
        }

        public boolean isServerOnly() {
            return this.serverOnly;
        }

        @Override
        public void save() {
            if (this.file == null) {
                LOGGER.warn("Failed to save config, its file wasn't set.");
                return;
            }
            if (this.isServerManaged() && FactoryAPI.currentServer == null && FactoryAPI.isClient() && FactoryAPIClient.hasLevel()) {
                return;
            }
            ((Consumer)this.preSave.invoker).accept(this);
            if (FactoryConfig.save(this.file, this.configMap, false)) {
                ((Consumer)this.afterSave.invoker).accept(this);
            }
        }

        public void load() {
            if (this.file == null) {
                LOGGER.warn("Failed to load config, its file wasn't set.");
                return;
            }
            ((Consumer)this.preLoad.invoker).accept(this);
            if (this.defaultFile != null) {
                FactoryConfig.load(this.defaultFile, this.configMap, true);
            }
            if (FactoryConfig.load(this.file, this.configMap, false)) {
                ((Consumer)this.afterLoad.invoker).accept(this);
            } else {
                this.reset();
                this.save();
            }
        }

        public <T> void decodeConfigs(Dynamic<T> dynamic) {
            FactoryConfig.decodeConfigs(this.configMap, dynamic);
        }

        public <T> T encodeConfigs(DynamicOps<T> ops) {
            return FactoryConfig.encodeConfigs(this.configMap, ops);
        }

        public <T> FactoryConfig<T> register(String key, FactoryConfig<T> config) {
            this.configMap.put(key, config);
            return config;
        }

        public <T> FactoryConfig<T> register(FactoryConfig<T> config) {
            return this.register(config.getKey(), config);
        }
    }
}

