/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.neoforge;

import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformHandlerApi;
import wily.factoryapi.base.TransportState;

public interface NeoForgeEnergyHandlerPlatform
extends IPlatformEnergyStorage,
IPlatformHandlerApi<EnergyHandler> {
    @Override
    default public int receiveEnergy(int energy, boolean simulate) {
        try (Transaction transaction = Transaction.open(null);){
            int amount = ((EnergyHandler)this.getHandler()).insert(energy, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            int n = amount;
            return n;
        }
    }

    @Override
    default public int consumeEnergy(int energy, boolean simulate) {
        try (Transaction transaction = Transaction.open(null);){
            int amount = ((EnergyHandler)this.getHandler()).extract(energy, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            int n = amount;
            return n;
        }
    }

    @Override
    default public int getEnergyStored() {
        return ((EnergyHandler)this.getHandler()).getAmountAsInt();
    }

    @Override
    default public int getMaxEnergyStored() {
        return ((EnergyHandler)this.getHandler()).getCapacityAsInt();
    }

    @Override
    default public void setEnergyStored(int energy) {
        if (this.getEnergyStored() > 0 && this.getEnergyStored() != energy) {
            this.consumeEnergy(this.getEnergyStored(), false);
        }
        this.receiveEnergy(energy, false);
    }

    @Override
    default public TransportState getTransport() {
        return TransportState.EXTRACT_INSERT;
    }

    @Override
    default public CompoundTag serializeTag() {
        return new CompoundTag();
    }

    @Override
    default public void deserializeTag(CompoundTag nbt) {
    }
}

